/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.statements;

import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.statements.BlockStatementNode;
import org.ballerinalang.model.tree.statements.TransactionNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;

public class BLangTransaction
extends BLangStatement
implements TransactionNode {
    public BLangBlockStmt transactionBody;
    public BLangBlockStmt onRetryBody;
    public BLangBlockStmt committedBody;
    public BLangBlockStmt abortedBody;
    public BLangExpression retryCount;

    public BLangTransaction() {
    }

    public BLangTransaction(BLangBlockStmt transactionBody, BLangBlockStmt onRetryBody, BLangExpression retryCount) {
        this.transactionBody = transactionBody;
        this.onRetryBody = onRetryBody;
        this.retryCount = retryCount;
    }

    @Override
    public BLangBlockStmt getTransactionBody() {
        return this.transactionBody;
    }

    @Override
    public BLangBlockStmt getOnRetryBody() {
        return this.onRetryBody;
    }

    @Override
    public ExpressionNode getRetryCount() {
        return this.retryCount;
    }

    @Override
    public BLangBlockStmt getAbortedBody() {
        return this.abortedBody;
    }

    @Override
    public BLangBlockStmt getCommittedBody() {
        return this.committedBody;
    }

    @Override
    public void setTransactionBody(BlockStatementNode body) {
        this.transactionBody = (BLangBlockStmt)body;
    }

    @Override
    public void setOnRetryBody(BlockStatementNode body) {
        this.onRetryBody = (BLangBlockStmt)body;
    }

    @Override
    public void setRetryCount(ExpressionNode retryCount) {
        this.retryCount = (BLangExpression)retryCount;
    }

    @Override
    public void setCommittedBody(BlockStatementNode committedBlock) {
        this.committedBody = (BLangBlockStmt)committedBlock;
    }

    @Override
    public void setAbortedBody(BlockStatementNode abortedBlock) {
        this.abortedBody = (BLangBlockStmt)abortedBlock;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.TRANSACTION;
    }

    public String toString() {
        return "Transaction: {" + this.transactionBody + "} " + (this.onRetryBody != null ? " failed {" + String.valueOf(this.onRetryBody) + "}" : "") + (this.retryCount != null ? " retry (" + this.retryCount + ")" : "");
    }
}

