/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util.diagnotic;

import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BDiagnostic
implements Diagnostic {
    public Diagnostic.Kind kind;
    public DiagnosticPos pos;
    public String msg;
    public DiagnosticCode code;

    public BDiagnostic() {
    }

    public BDiagnostic(Diagnostic.Kind kind, DiagnosticPos pos, DiagnosticCode code, String msg) {
        this.kind = kind;
        this.pos = pos;
        this.code = code;
        this.msg = msg;
    }

    public BDiagnostic(Diagnostic.Kind kind, DiagnosticPos pos, String msg) {
        this.kind = kind;
        this.pos = pos;
        this.msg = msg;
    }

    @Override
    public Diagnostic.Kind getKind() {
        return this.kind;
    }

    @Override
    public Diagnostic.DiagnosticSource getSource() {
        return this.pos.getSource();
    }

    @Override
    public Diagnostic.DiagnosticPosition getPosition() {
        return this.pos;
    }

    @Override
    public String getMessage() {
        return this.msg;
    }

    @Override
    public DiagnosticCode getCode() {
        return this.code;
    }

    public int hashCode() {
        return this.kind.hashCode() + this.pos.hashCode() + this.msg.hashCode() + this.code.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BDiagnostic)) {
            return false;
        }
        BDiagnostic diagnostic = (BDiagnostic)obj;
        return this.kind == diagnostic.kind && this.pos.equals(diagnostic.pos) && this.msg.equals(diagnostic.msg) && this.code == diagnostic.code;
    }

    @Override
    public int compareTo(Diagnostic diagnostic) {
        int value = this.pos.compareTo(diagnostic.getPosition());
        if (value != 0) {
            return value;
        }
        return this.msg.compareTo(diagnostic.getMessage());
    }

    public String toString() {
        return (Object)((Object)this.kind) + ": " + this.pos + ": " + this.msg;
    }
}

