/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.util;

import java.util.HashSet;
import java.util.Set;
import org.ballerinalang.model.elements.Flag;

public class Flags {
    public static final int PUBLIC = 1;
    public static final int NATIVE = 2;
    public static final int FINAL = 4;
    public static final int ATTACHED = 8;
    public static final int DEPRECATED = 16;
    public static final int READONLY = 32;
    public static final int FUNCTION_FINAL = 64;
    public static final int INTERFACE = 128;
    public static final int REQUIRED = 256;
    public static final int RECORD = 512;
    public static final int PRIVATE = 1024;
    public static final int ANONYMOUS = 2048;
    public static final int ABSTRACT = 4096;
    public static final int OPTIONAL = 8192;
    public static final int TESTABLE = 16384;
    public static final int CONSTANT = 32768;
    public static final int REMOTE = 65536;
    public static final int CLIENT = 131072;
    public static final int RESOURCE = 262144;
    public static final int SERVICE = 524288;
    public static final int LISTENER = 0x100000;
    public static final int LAMBDA = 0x200000;
    public static final int TYPE_PARAM = 0x400000;
    public static final int LANG_LIB = 0x800000;
    public static final int WORKER = 0x1000000;
    public static final int FORKED = 0x2000000;

    public static int asMask(Set<Flag> flagSet) {
        int mask = 0;
        for (Flag flag : flagSet) {
            switch (flag) {
                case PUBLIC: {
                    mask |= 1;
                    break;
                }
                case PRIVATE: {
                    mask |= 0x400;
                    break;
                }
                case REMOTE: {
                    mask |= 0x10000;
                    break;
                }
                case NATIVE: {
                    mask |= 2;
                    break;
                }
                case FINAL: {
                    mask |= 4;
                    break;
                }
                case ATTACHED: {
                    mask |= 8;
                    break;
                }
                case READONLY: {
                    mask |= 0x20;
                    break;
                }
                case FUNCTION_FINAL: {
                    mask |= 0x40;
                    break;
                }
                case INTERFACE: {
                    mask |= 0x80;
                    break;
                }
                case REQUIRED: {
                    mask |= 0x100;
                    break;
                }
                case RECORD: {
                    mask |= 0x200;
                    break;
                }
                case ANONYMOUS: {
                    mask |= 0x800;
                    break;
                }
                case ABSTRACT: {
                    mask |= 0x1000;
                    break;
                }
                case OPTIONAL: {
                    mask |= 0x2000;
                    break;
                }
                case TESTABLE: {
                    mask |= 0x4000;
                    break;
                }
                case CLIENT: {
                    mask |= 0x20000;
                    break;
                }
                case RESOURCE: {
                    mask |= 0x40000;
                    break;
                }
                case SERVICE: {
                    mask |= 0x80000;
                    break;
                }
                case LISTENER: {
                    mask |= 0x100000;
                    break;
                }
                case CONSTANT: {
                    mask |= 0x8000;
                    break;
                }
                case LAMBDA: {
                    mask |= 0x200000;
                    break;
                }
                case TYPE_PARAM: {
                    mask |= 0x400000;
                    break;
                }
                case LANG_LIB: {
                    mask |= 0x800000;
                    break;
                }
                case WORKER: {
                    mask |= 0x1000000;
                    break;
                }
                case FORKED: {
                    mask |= 0x2000000;
                }
            }
        }
        return mask;
    }

    public static Set<Flag> unMask(int mask) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        block25: for (Flag flag : Flag.values()) {
            int flagVal;
            switch (flag) {
                case PUBLIC: {
                    flagVal = 1;
                    break;
                }
                case PRIVATE: {
                    flagVal = 1024;
                    break;
                }
                case REMOTE: {
                    flagVal = 65536;
                    break;
                }
                case NATIVE: {
                    flagVal = 2;
                    break;
                }
                case FINAL: {
                    flagVal = 4;
                    break;
                }
                case ATTACHED: {
                    flagVal = 8;
                    break;
                }
                case READONLY: {
                    flagVal = 32;
                    break;
                }
                case FUNCTION_FINAL: {
                    flagVal = 64;
                    break;
                }
                case INTERFACE: {
                    flagVal = 128;
                    break;
                }
                case REQUIRED: {
                    flagVal = 256;
                    break;
                }
                case RECORD: {
                    flagVal = 512;
                    break;
                }
                case ANONYMOUS: {
                    flagVal = 2048;
                    break;
                }
                case ABSTRACT: {
                    flagVal = 4096;
                    break;
                }
                case OPTIONAL: {
                    flagVal = 8192;
                    break;
                }
                case CLIENT: {
                    flagVal = 131072;
                    break;
                }
                case RESOURCE: {
                    flagVal = 262144;
                    break;
                }
                case SERVICE: {
                    flagVal = 524288;
                    break;
                }
                case LISTENER: {
                    flagVal = 0x100000;
                    break;
                }
                case CONSTANT: {
                    flagVal = 32768;
                    break;
                }
                case LAMBDA: {
                    flagVal = 0x200000;
                    break;
                }
                case TYPE_PARAM: {
                    flagVal = 0x400000;
                    break;
                }
                case LANG_LIB: {
                    flagVal = 0x800000;
                    break;
                }
                case FORKED: {
                    flagVal = 0x2000000;
                    break;
                }
                default: {
                    continue block25;
                }
            }
            Flags.addIfFlagOn(flagSet, mask, flagVal, flag);
        }
        return flagSet;
    }

    private static void addIfFlagOn(Set<Flag> flagSet, int mask, int flagVal, Flag flag) {
        if ((mask & flagVal) == flagVal) {
            flagSet.add(flag);
        }
    }
}

