/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.kraal;

import com.hpe.kraal.After;
import com.hpe.kraal.Append;
import com.hpe.kraal.Before;
import com.hpe.kraal.InsertionLocation;
import com.hpe.kraal.Instruction;
import com.hpe.kraal.InstructionClonerKt;
import com.hpe.kraal.MethodControlFlowGraph;
import com.hpe.kraal.MethodControlFlowGraphKt;
import com.hpe.kraal.NodeSplitterKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001af\u0010\f\u001a\u00020\u000b*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2<\u0010\u0012\u001a8\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00100\u0017\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u000b0\u0013H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "removeIrreducibleLoops", "", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "method", "Lorg/objectweb/asm/tree/MethodNode;", "removeIrreducibleLoopsWithoutVerification", "verifyProcessedCorrectly", "", "cloneRegion", "Lcom/hpe/kraal/MethodControlFlowGraph;", "toClone", "", "Lcom/hpe/kraal/Instruction;", "ownedBy", "addToRegion", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "vertex", "Lcom/hpe/kraal/InsertionLocation;", "location", "kraal"})
public final class ControlFlowGraphSplitterKt {
    private static final Logger log = LoggerFactory.getLogger((String)"com.hpe.kraal.ControlFlowGraphSplitterKt");

    public static final boolean removeIrreducibleLoops(@NotNull ClassNode classNode, @NotNull MethodNode method) {
        Intrinsics.checkParameterIsNotNull((Object)classNode, (String)"classNode");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        boolean modified = ControlFlowGraphSplitterKt.removeIrreducibleLoopsWithoutVerification(classNode, method);
        if (modified) {
            ControlFlowGraphSplitterKt.verifyProcessedCorrectly(method, classNode);
        }
        return modified;
    }

    private static final boolean removeIrreducibleLoopsWithoutVerification(ClassNode classNode, MethodNode method) {
        if (method.instructions.size() == 0) {
            return false;
        }
        Logger logger = log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        Logger $receiver$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger2 = $receiver$iv;
            boolean bl = false;
            String string = "Computing control flow graph for " + classNode.name + '.' + method.name;
            logger2.debug(string, t$iv);
        }
        MethodControlFlowGraph graph = MethodControlFlowGraphKt.computeControlFlowGraph(method, classNode);
        if (graph.getGuaranteedAcyclic()) {
            return false;
        }
        return NodeSplitterKt.removeIrreducibleLoops(graph, (Function3)new Function3<Collection<? extends Instruction>, Collection<? extends Instruction>, Function2<? super Instruction, ? super InsertionLocation<? extends Instruction>, ? extends Unit>, Unit>(graph){
            final /* synthetic */ MethodControlFlowGraph $graph;

            public final void invoke(@NotNull Collection<Instruction> toClone, @NotNull Collection<Instruction> ownedBy, @NotNull Function2<? super Instruction, ? super InsertionLocation<Instruction>, Unit> addInstruction) {
                Intrinsics.checkParameterIsNotNull(toClone, (String)"toClone");
                Intrinsics.checkParameterIsNotNull(ownedBy, (String)"ownedBy");
                Intrinsics.checkParameterIsNotNull(addInstruction, (String)"addInstruction");
                ControlFlowGraphSplitterKt.access$cloneRegion(this.$graph, toClone, ownedBy, addInstruction);
            }
            {
                this.$graph = methodControlFlowGraph;
                super(3);
            }
        });
    }

    private static final void cloneRegion(@NotNull MethodControlFlowGraph $receiver, Collection<Instruction> toClone, Collection<Instruction> ownedBy, Function2<? super Instruction, ? super InsertionLocation<Instruction>, Unit> addToRegion) {
        InstructionClonerKt.cloneInstructions($receiver, toClone, ownedBy, (Function2<? super AbstractInsnNode, ? super InsertionLocation<Instruction>, Instruction>)((Function2)new Function2<AbstractInsnNode, InsertionLocation<? extends Instruction>, Instruction>($receiver, addToRegion){
            final /* synthetic */ MethodControlFlowGraph $this_cloneRegion;
            final /* synthetic */ Function2 $addToRegion;

            @NotNull
            public final Instruction invoke(@NotNull AbstractInsnNode toAdd, @NotNull InsertionLocation<Instruction> location) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)toAdd, (String)"toAdd");
                Intrinsics.checkParameterIsNotNull(location, (String)"location");
                InsertionLocation<Instruction> insertionLocation = location;
                if (insertionLocation instanceof Before) {
                    this.$this_cloneRegion.getMethod().instructions.insertBefore(((Instruction)((Before)location).getNext()).getAsm(), toAdd);
                    n = ((Instruction)((Before)location).getNext()).getIndex();
                } else if (insertionLocation instanceof After) {
                    this.$this_cloneRegion.getMethod().instructions.insert(((Instruction)((After)location).getPrev()).getAsm(), toAdd);
                    n = ((Instruction)((After)location).getPrev()).getIndex() + 1;
                } else if (insertionLocation instanceof Append) {
                    this.$this_cloneRegion.getMethod().instructions.add(toAdd);
                    n = this.$this_cloneRegion.getVertices().size();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                int index = n;
                InsnList insnList = this.$this_cloneRegion.getMethod().instructions;
                Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"method.instructions");
                Instruction instruction = new Instruction(toAdd, insnList, null, null, null, null, 60, null);
                this.$this_cloneRegion.getInstructions().add(index, instruction);
                this.$addToRegion.invoke((Object)instruction, location);
                return instruction;
            }
            {
                this.$this_cloneRegion = methodControlFlowGraph;
                this.$addToRegion = function2;
                super(2);
            }
        }));
    }

    private static final void verifyProcessedCorrectly(MethodNode method, ClassNode classNode) {
        boolean bl;
        MethodControlFlowGraph newCFG = MethodControlFlowGraphKt.computeControlFlowGraph(method, classNode);
        boolean bl2 = bl = !ControlFlowGraphSplitterKt.removeIrreducibleLoopsWithoutVerification(classNode, method);
        if (!bl) {
            boolean bl3 = false;
            String string = "After removeIrreducibleLoops, still found loop(s) with undominated entrypoints in " + newCFG.getName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public static final /* synthetic */ void access$cloneRegion(MethodControlFlowGraph $receiver, Collection toClone, Collection ownedBy, Function2 addToRegion) {
        ControlFlowGraphSplitterKt.cloneRegion($receiver, toClone, ownedBy, (Function2<? super Instruction, ? super InsertionLocation<Instruction>, Unit>)addToRegion);
    }
}

