/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.kraal;

import com.hpe.kraal.ASMUtilsKt;
import com.hpe.kraal.ControlFlowGraphSplitterKt;
import com.hpe.kraal.FileHandlerKt;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a2\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0018\b\u0002\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e\u001a\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "processClassFile", "", "classFile", "Ljava/nio/file/Path;", "classloader", "Ljava/lang/ClassLoader;", "removeIrreducibleLoops", "file", "excludeList", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "kraal"})
public final class FileHandlerKt {
    private static final Logger log = LoggerFactory.getLogger((String)"com.hpe.kraal.FileHandlerKt");

    public static final boolean removeIrreducibleLoops(@NotNull ClassNode classNode) {
        Intrinsics.checkParameterIsNotNull((Object)classNode, (String)"classNode");
        boolean modified = false;
        Iterator iterator = classNode.methods.iterator();
        while (iterator.hasNext()) {
            MethodNode method;
            MethodNode methodNode = method = (MethodNode)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodNode, (String)"method");
            modified = ControlFlowGraphSplitterKt.removeIrreducibleLoops(classNode, methodNode) || modified;
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean removeIrreducibleLoops(@NotNull Path file, @NotNull ClassLoader classloader, @NotNull ArrayList<String> excludeList) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)classloader, (String)"classloader");
        Intrinsics.checkParameterIsNotNull(excludeList, (String)"excludeList");
        if (StringsKt.endsWith$default((String)((Object)file).toString(), (String)".class", (boolean)false, (int)2, null)) {
            return FileHandlerKt.processClassFile(file, classloader);
        }
        if (StringsKt.endsWith$default((String)((Object)file).toString(), (String)".jar", (boolean)false, (int)2, null)) {
            Logger logger = log;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
            Object $receiver$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$info = false;
            if ($receiver$iv.isInfoEnabled()) {
                Logger logger2 = $receiver$iv;
                boolean bl = false;
                String string = "Processing jar file " + file;
                logger2.info(string, t$iv);
            }
            $receiver$iv = FileSystems.newFileSystem(file, null);
            t$iv = null;
            try {
                FileSystem zipfs = (FileSystem)$receiver$iv;
                boolean bl = false;
                Stream<Path> classes2 = Files.walk(zipfs.getPath("/", new String[0]), new FileVisitOption[0]).filter(removeIrreducibleLoops.2.classes.1.INSTANCE);
                Stream<Path> mClasses = classes2.filter(new Predicate<Path>(excludeList, classloader){
                    final /* synthetic */ ArrayList $excludeList$inlined;
                    final /* synthetic */ ClassLoader $classloader$inlined;
                    {
                        this.$excludeList$inlined = arrayList;
                        this.$classloader$inlined = classLoader;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean test(Path className) {
                        void $receiver$iv$iv;
                        Iterable $receiver$iv;
                        Iterable iterable = $receiver$iv = (Iterable)this.$excludeList$inlined;
                        Collection destination$iv$iv = new ArrayList<E>();
                        for (T element$iv$iv : $receiver$iv$iv) {
                            String pattern = (String)element$iv$iv;
                            boolean bl = false;
                            if (!StringsKt.contains$default((CharSequence)((Object)className).toString(), (CharSequence)pattern, (boolean)false, (int)2, null)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        return ((List)destination$iv$iv).isEmpty();
                    }
                });
                boolean modified = false;
                Iterator iterator = mClasses.iterator();
                while (iterator.hasNext()) {
                    Path classFile;
                    Path path = classFile = (Path)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"classFile");
                    modified = FileHandlerKt.processClassFile(path, classloader) || modified;
                }
                boolean bl2 = modified;
                return bl2;
            }
            catch (Throwable zipfs) {
                t$iv = zipfs;
                throw zipfs;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$receiver$iv, (Throwable)t$iv);
            }
        }
        Logger logger = log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        Logger $receiver$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger3 = $receiver$iv;
            boolean bl = false;
            String string = "Not processing input file " + file;
            logger3.debug(string, t$iv);
        }
        return false;
    }

    public static /* synthetic */ boolean removeIrreducibleLoops$default(Path path, ClassLoader classLoader, ArrayList arrayList, int n, Object object) {
        if ((n & 2) != 0) {
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            ClassLoader classLoader2 = thread.getContextClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"Thread.currentThread().contextClassLoader");
            classLoader = classLoader2;
        }
        if ((n & 4) != 0) {
            arrayList = new ArrayList<String>();
        }
        return FileHandlerKt.removeIrreducibleLoops(path, classLoader, arrayList);
    }

    private static final boolean processClassFile(Path classFile, ClassLoader classloader) {
        String string;
        Logger logger;
        Logger logger2 = log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"log");
        Logger $receiver$iv = logger2;
        Throwable t$iv = null;
        boolean $i$f$info = false;
        if ($receiver$iv.isInfoEnabled()) {
            logger = $receiver$iv;
            boolean bl = false;
            string = "Processing " + classFile;
            logger.info(string, t$iv);
        }
        ClassNode classNode = ASMUtilsKt.readClassFile(classFile);
        if (FileHandlerKt.removeIrreducibleLoops(classNode)) {
            ASMUtilsKt.writeToFile(classNode, classFile, classloader);
            Logger logger3 = log;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger3, (String)"log");
            Logger $receiver$iv2 = logger3;
            Throwable t$iv2 = null;
            boolean $i$f$info2 = false;
            if ($receiver$iv2.isInfoEnabled()) {
                logger = $receiver$iv2;
                boolean bl = false;
                string = "Updated " + classFile;
                logger.info(string, t$iv2);
            }
            return true;
        }
        return false;
    }
}

