/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.producer;

import io.nats.client.Connection;
import io.nats.client.Message;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.nats.Constants;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsUtil;
import org.ballerinalang.nats.observability.NatsTracingUtil;

public class Request {
    public static Object externRequest(ObjectValue producerObject, String subject, Object data, Object duration) {
        NatsTracingUtil.traceResourceInvocation(Scheduler.getStrand(), producerObject, subject);
        Object connection = producerObject.get("conn");
        if (TypeChecker.getType((Object)connection).getTag() == 34) {
            ObjectValue connectionObject = (ObjectValue)connection;
            Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
            if (natsConnection == null) {
                NatsMetricsUtil.reportProducerError("request");
                return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while publishing message to subject " + subject + ". NATS connection doesn't exist."));
            }
            NatsMetricsUtil natsMetricsUtil = (NatsMetricsUtil)connectionObject.getNativeData("nats_metric_util");
            byte[] byteContent = Utils.convertDataIntoByteArray(data);
            try {
                CompletableFuture incoming = natsConnection.request(subject, byteContent);
                natsMetricsUtil.reportRequest(subject, byteContent.length);
                Message reply = TypeChecker.getType((Object)duration).getTag() == 1 ? (Message)incoming.get((Long)duration, TimeUnit.MILLISECONDS) : (Message)incoming.get();
                ArrayValueImpl msgData = new ArrayValueImpl(reply.getData());
                natsMetricsUtil.reportResponse(subject);
                ObjectValue msgObj = BallerinaValues.createObjectValue((BPackage)Constants.NATS_PACKAGE_ID, (String)"Message", (Object[])new Object[]{reply.getSubject(), msgData, reply.getReplyTo()});
                msgObj.addNativeData("NATSMSG", (Object)reply);
                return msgObj;
            }
            catch (TimeoutException ex) {
                natsMetricsUtil.reportProducerError(subject, "request");
                return Utils.createNatsError("Request to subject " + subject + " timed out while waiting for a reply");
            }
            catch (IllegalArgumentException | IllegalStateException | ExecutionException ex) {
                natsMetricsUtil.reportProducerError(subject, "request");
                return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while requesting message to subject " + subject + ". " + ex.getMessage()));
            }
            catch (InterruptedException ex) {
                natsMetricsUtil.reportProducerError(subject, "request");
                Thread.currentThread().interrupt();
                return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while requesting message to subject " + subject + ". " + ex.getMessage()));
            }
        }
        NatsMetricsUtil.reportProducerError("request");
        return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while publishing message to subject " + subject + ". Producer is logically disconnected."));
    }
}

