/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.connection;

import io.nats.client.Connection;
import io.nats.client.Consumer;
import io.nats.client.ErrorListener;
import org.ballerinalang.nats.observability.NatsMetricsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultErrorListener
implements ErrorListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultErrorListener.class);

    DefaultErrorListener() {
    }

    public void errorOccurred(Connection conn, String error) {
        String message = "Error in server " + conn.getConnectedUrl() + ". " + error;
        NatsMetricsUtil.reportConnectionError(conn.getConnectedUrl(), "unknown");
        LOG.error(message);
    }

    public void exceptionOccurred(Connection conn, Exception exp) {
        LOG.error("Exception in server " + conn.getConnectedUrl() + exp.getMessage());
        NatsMetricsUtil.reportConnectionError(conn.getConnectedUrl(), "exception");
    }

    public void slowConsumerDetected(Connection conn, Consumer consumer) {
        LOG.error("slow consumer detected in server " + conn.getConnectedUrl() + " | " + consumer.toString());
        NatsMetricsUtil.reportConnectionError(conn.getConnectedUrl(), "slow_consumer");
    }
}

