/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.streaming.consumer;

import io.nats.streaming.Message;
import io.nats.streaming.MessageHandler;
import java.util.HashMap;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.services.ErrorHandlerUtils;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.nats.Constants;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsUtil;
import org.ballerinalang.nats.observability.NatsObserverContext;

public class StreamingListener
implements MessageHandler {
    private ObjectValue service;
    private BRuntime runtime;
    private String connectedUrl;
    private boolean manualAck;
    private NatsMetricsUtil natsMetricsUtil;

    public StreamingListener(ObjectValue service, boolean manualAck, BRuntime runtime, String connectedUrl, NatsMetricsUtil natsMetricsUtil) {
        this.service = service;
        this.runtime = runtime;
        this.manualAck = manualAck;
        this.natsMetricsUtil = natsMetricsUtil;
        this.connectedUrl = connectedUrl;
    }

    public void onMessage(Message msg) {
        this.natsMetricsUtil.reportConsume(msg.getSubject(), msg.getData().length);
        ObjectValue ballerinaNatsMessage = BallerinaValues.createObjectValue((BPackage)Constants.NATS_PACKAGE_ID, (String)"StreamingMessage", (Object[])new Object[]{msg.getSubject(), BValueCreator.createArrayValue((byte[])msg.getData()), msg.getReplyTo()});
        ballerinaNatsMessage.addNativeData("nats_streaming_message", (Object)msg);
        ballerinaNatsMessage.addNativeData("manualAck", (Object)this.manualAck);
        AttachedFunction onMessageResource = Utils.getAttachedFunction(this.service, "onMessage");
        BType[] parameterTypes = onMessageResource.getParameterType();
        if (parameterTypes.length == 1) {
            this.dispatch(ballerinaNatsMessage, msg.getSubject());
        } else {
            BType intendedTypeForData = parameterTypes[1];
            this.dispatch(ballerinaNatsMessage, intendedTypeForData, msg.getData(), msg.getSubject());
        }
    }

    private void dispatch(ObjectValue ballerinaNatsMessage, String subject) {
        this.executeResource(subject, ballerinaNatsMessage);
    }

    private void dispatch(ObjectValue ballerinaNatsMessage, BType intendedTypeForData, byte[] data, String subject) {
        try {
            Object typeBoundData = Utils.bindDataToIntendedType(data, intendedTypeForData);
            this.executeResource(subject, ballerinaNatsMessage, typeBoundData);
        }
        catch (NumberFormatException e) {
            ErrorValue dataBindError = Utils.createNatsError("The received message is unsupported by the resource signature");
            this.natsMetricsUtil.reportConsumerError(subject, "message_received");
            this.executeErrorResource(subject, ballerinaNatsMessage, dataBindError);
        }
        catch (ErrorValue e) {
            this.executeErrorResource(subject, ballerinaNatsMessage, e);
            this.natsMetricsUtil.reportConsumerError(subject, "message_received");
        }
    }

    private void executeResource(String subject, ObjectValue ballerinaNatsMessage) {
        if (ObserveUtils.isTracingEnabled()) {
            HashMap<String, NatsObserverContext> properties = new HashMap<String, NatsObserverContext>();
            NatsObserverContext observerContext = new NatsObserverContext("consumer", this.connectedUrl, subject);
            properties.put("__observer_context__", observerContext);
            this.runtime.invokeMethodAsync(this.service, "onMessage", (CallableUnitCallback)new DispatcherCallback(subject, this.natsMetricsUtil), properties, new Object[]{ballerinaNatsMessage, true});
        } else {
            this.runtime.invokeMethodAsync(this.service, "onMessage", (CallableUnitCallback)new DispatcherCallback(subject, this.natsMetricsUtil), null, new Object[]{ballerinaNatsMessage, true});
        }
    }

    private void executeResource(String subject, ObjectValue ballerinaNatsMessage, Object typeBoundData) {
        if (ObserveUtils.isTracingEnabled()) {
            HashMap<String, NatsObserverContext> properties = new HashMap<String, NatsObserverContext>();
            NatsObserverContext observerContext = new NatsObserverContext("consumer", this.connectedUrl, subject);
            properties.put("__observer_context__", observerContext);
            this.runtime.invokeMethodAsync(this.service, "onMessage", (CallableUnitCallback)new DispatcherCallback(subject, this.natsMetricsUtil), properties, new Object[]{ballerinaNatsMessage, true, typeBoundData, true});
        } else {
            this.runtime.invokeMethodAsync(this.service, "onMessage", (CallableUnitCallback)new DispatcherCallback(subject, this.natsMetricsUtil), null, new Object[]{ballerinaNatsMessage, true, typeBoundData, true});
        }
    }

    private void executeErrorResource(String subject, ObjectValue ballerinaNatsMessage, ErrorValue error) {
        if (ObserveUtils.isTracingEnabled()) {
            HashMap<String, NatsObserverContext> properties = new HashMap<String, NatsObserverContext>();
            NatsObserverContext observerContext = new NatsObserverContext("consumer", this.connectedUrl, subject);
            properties.put("__observer_context__", observerContext);
            this.runtime.invokeMethodAsync(this.service, "onError", (CallableUnitCallback)new DispatcherCallback(subject, this.natsMetricsUtil), properties, new Object[]{ballerinaNatsMessage, true, error, true});
        } else {
            this.runtime.invokeMethodAsync(this.service, "onError", (CallableUnitCallback)new DispatcherCallback(subject, this.natsMetricsUtil), null, new Object[]{ballerinaNatsMessage, true, error, true});
        }
    }

    private static class DispatcherCallback
    implements CallableUnitCallback {
        private String subject;
        private NatsMetricsUtil natsMetricsUtil;

        public DispatcherCallback(String subject, NatsMetricsUtil natsMetricsUtil) {
            this.subject = subject;
            this.natsMetricsUtil = natsMetricsUtil;
        }

        public void notifySuccess() {
            this.natsMetricsUtil.reportDelivery(this.subject);
        }

        public void notifyFailure(ErrorValue error) {
            this.natsMetricsUtil.reportConsumerError(this.subject, "message_received");
            ErrorHandlerUtils.printError((Throwable)error);
        }
    }
}

