/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.service.compiler;

import java.util.List;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;

@SupportedResourceParamTypes(expectedListenerType=@SupportedResourceParamTypes.Type(packageName="file", name="Listener"), paramTypes={@SupportedResourceParamTypes.Type(packageName="file", name="FileEvent")})
public class DirectoryListenerCompilerPlugin
extends AbstractCompilerPlugin {
    private DiagnosticLog dlog = null;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(ServiceNode serviceData, List<AnnotationAttachmentNode> annotations) {
        List resources = serviceData.getResources();
        resources.forEach(res -> this.validate(serviceData.getName().getValue(), (BLangFunction)res, this.dlog));
    }

    public void validate(String serviceName, BLangFunction resource, DiagnosticLog dlog) {
        switch (resource.getName().getValue()) {
            case "onCreate": 
            case "onDelete": 
            case "onModify": {
                List parameters = resource.getParameters();
                String msg = "Invalid resource signature for %s in service %s. The parameter should be a file:FileEvent with no returns.";
                msg = String.format(msg, resource.getName().getValue(), serviceName);
                if (parameters.size() != 1) {
                    dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.getPosition(), (CharSequence)msg);
                    return;
                }
                BType fileEvent = ((BLangSimpleVariable)parameters.get((int)0)).getTypeNode().type;
                if (!fileEvent.getKind().equals((Object)TypeKind.OBJECT) || !(fileEvent instanceof BStructureType)) break;
                BStructureType event = (BStructureType)fileEvent;
                if ("file".equals(event.tsymbol.pkgID.name.value) && "FileEvent".equals(event.tsymbol.name.value)) break;
                dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.getPosition(), (CharSequence)msg);
                return;
            }
            default: {
                dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.getPosition(), (CharSequence)("Invalid resource name " + resource.getName().getValue() + " in service " + serviceName));
            }
        }
    }
}

