/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.trace.extension.zipkin.sampler;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import org.ballerinalang.observe.trace.extension.zipkin.sampler.RateLimiter;

public class RateLimitingSampler
implements Sampler {
    public static final String TYPE = "ratelimiting";
    private static final AttributeKey<String> SAMPLER_TYPE = AttributeKey.stringKey((String)"sampler.type");
    private static final AttributeKey<Double> SAMPLER_PARAM = AttributeKey.doubleKey((String)"sampler.param");
    private final RateLimiter rateLimiter;
    private final SamplingResult onSamplingResult;
    private final SamplingResult offSamplingResult;
    private final String description;

    public RateLimitingSampler(int maxTracesPerSecond) {
        double maxBalance = (double)maxTracesPerSecond < 1.0 ? 1.0 : (double)maxTracesPerSecond;
        this.rateLimiter = new RateLimiter(maxTracesPerSecond, maxBalance, Clock.getDefault());
        Attributes attributes = Attributes.of(SAMPLER_TYPE, (Object)TYPE, SAMPLER_PARAM, (Object)maxTracesPerSecond);
        this.onSamplingResult = SamplingResult.create((SamplingDecision)SamplingDecision.RECORD_AND_SAMPLE, (Attributes)attributes);
        this.offSamplingResult = SamplingResult.create((SamplingDecision)SamplingDecision.DROP, (Attributes)attributes);
        this.description = "RateLimitingSampler{" + RateLimitingSampler.decimalFormat(maxTracesPerSecond) + "}";
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return this.rateLimiter.checkCredit(1.0) ? this.onSamplingResult : this.offSamplingResult;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }

    private static String decimalFormat(double value) {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("0.00", decimalFormatSymbols);
        return decimalFormat.format(value);
    }
}

