/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.rest.auth;

import io.ballerina.messaging.broker.auth.AuthException;
import io.ballerina.messaging.broker.auth.UsernamePrincipal;
import io.ballerina.messaging.broker.auth.authentication.AuthResult;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Base64;
import javax.security.auth.Subject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.interceptor.RequestInterceptor;

public class BasicAuthSecurityInterceptor
implements RequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicAuthSecurityInterceptor.class);
    private static final String AUTH_TYPE_BASIC = "Basic";
    private static final int AUTH_TYPE_BASIC_LENGTH = "Basic".length();
    private AuthenticateFunction<AuthException> authenticateFunction;

    public BasicAuthSecurityInterceptor(AuthenticateFunction<AuthException> authenticateFunction) {
        this.authenticateFunction = authenticateFunction;
    }

    public boolean interceptRequest(Request request, Response response) throws Exception {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            char[] password;
            int separatorIndex;
            byte[] decodedByte;
            char[] array;
            String userName;
            String authType = authHeader.substring(0, AUTH_TYPE_BASIC_LENGTH);
            String authEncoded = authHeader.substring(AUTH_TYPE_BASIC_LENGTH).trim();
            if (AUTH_TYPE_BASIC.equals(authType) && !authEncoded.isEmpty() && this.authenticate(userName = new String(Arrays.copyOfRange(array = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(decodedByte = Base64.getDecoder().decode(authEncoded.getBytes(StandardCharsets.UTF_8)))).array(), 0, separatorIndex = this.findIndex(array, ':'))), password = Arrays.copyOfRange(array, separatorIndex + 1, array.length))) {
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)new UsernamePrincipal(userName));
                request.getSession().setAttribute("AuthenticationId", (Object)subject);
                return true;
            }
        }
        response.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
        response.setHeader("WWW-Authenticate", AUTH_TYPE_BASIC);
        return false;
    }

    private int findIndex(char[] array, char value) {
        int startIndex = 0;
        if (array == null) {
            return -1;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    private boolean authenticate(String userName, char ... password) {
        try {
            return userName != null && this.authenticateFunction.authenticate(userName, password).isAuthenticated();
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error occurred while authenticating user", (Throwable)e);
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface AuthenticateFunction<E extends Exception> {
        public AuthResult authenticate(String var1, char ... var2) throws E;
    }
}

