/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.natives.test;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.values.AbstractObjectValue;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.Executor;
import org.ballerinalang.testerina.natives.test.MockRegistry;

public class FunctionMock {
    public static ErrorValue thenReturn(ObjectValue caseObj) {
        ObjectValue mockFunctionObj = caseObj.getObjectValue("mockFuncObj");
        ArrayValue args = caseObj.getArrayValue("args");
        Object returnVal = caseObj.get("returnValue");
        MockRegistry.getInstance().registerCase(mockFunctionObj, null, args, returnVal);
        return null;
    }

    public static Object mockHandler(ObjectValue mockFuncObj, Object ... args) {
        List<String> caseIds = FunctionMock.getCaseIds(mockFuncObj, args);
        String originalFunction = mockFuncObj.getStringValue("functionToMock");
        String originalFunctionPackage = mockFuncObj.getStringValue("functionToMockPackage");
        originalFunctionPackage = FunctionMock.formatFunctionPackage(originalFunctionPackage);
        String version = mockFuncObj.getStringValue("packageVersion");
        Object returnVal = null;
        for (String caseId : caseIds) {
            if (!MockRegistry.getInstance().hasCase(caseId)) continue;
            returnVal = MockRegistry.getInstance().getReturnValue(caseId);
            if (!returnVal.toString().contains("__CALL__")) break;
            return FunctionMock.callFunction(originalFunction, originalFunctionPackage, returnVal.toString(), version, args);
        }
        if (returnVal == null) {
            String detail = "no return value or action registered for function";
            return BallerinaErrors.createError((String)"FunctionCallError", (String)detail);
        }
        return returnVal;
    }

    private static Object callFunction(String originalFunction, String originalFunctionPackage, String returnVal, String version, Object ... args) {
        String className;
        String packageName;
        String orgName;
        int prefixPos = returnVal.indexOf("__CALL__");
        String methodName = returnVal.substring(prefixPos + "__CALL__".length());
        Strand strand = Scheduler.getStrand();
        try {
            String[] projectInfo = Thread.currentThread().getStackTrace()[4].getClassName().split(Pattern.quote("."));
            orgName = projectInfo[0];
            packageName = projectInfo[1];
            className = "tests." + FunctionMock.getClassName(methodName, orgName, packageName, version, originalFunction, originalFunctionPackage);
        }
        catch (IOException | ClassNotFoundException e) {
            return BallerinaErrors.createError((String)"FunctionCallError", (String)e.getMessage());
        }
        ArrayList<Object> argsList = new ArrayList<Object>();
        for (Object arg : args) {
            argsList.add(arg);
        }
        ClassLoader classLoader = FunctionMock.class.getClassLoader();
        return Executor.executeFunction((Scheduler)strand.scheduler, (ClassLoader)classLoader, (String)orgName, (String)packageName, (String)className, (String)methodName, (Object[])argsList.toArray());
    }

    private static String getClassName(String mockMethodName, String orgName, String packageName, String version, String originalMethodName, String originalPackageName) throws IOException, ClassNotFoundException {
        String jarName = orgName + "-" + packageName + "-" + version + "-testable.jar";
        Path jarPath = Paths.get(System.getProperty("user.dir"), "target", "caches", "jar_cache", orgName, packageName, version, jarName);
        Method mockMethod = null;
        Method originalMethod = null;
        try (JarFile jar = new JarFile(jarPath.toString());){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String file = entries.nextElement().getName();
                if (!file.endsWith(".class") || file.contains("Frame.class") || file.contains("__init") || !file.contains("/tests/") || mockMethod != null) continue;
                mockMethod = FunctionMock.getClassDeclaredMethod(file, mockMethodName);
            }
            originalMethod = FunctionMock.getOriginalMethod(originalMethodName, originalPackageName);
        }
        FunctionMock.validateFunctionSignature(mockMethod, originalMethod, mockMethodName);
        return mockMethod.getDeclaringClass().getSimpleName();
    }

    private static Method getOriginalMethod(String methodName, String packageName) throws ClassNotFoundException {
        Method[] methodList;
        for (Method method : methodList = FunctionMock.class.getClassLoader().loadClass(packageName).getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    private static void validateFunctionSignature(Method mockMethod, Method originalMethod, String mockMethodName) {
        if (mockMethod != null && originalMethod != null) {
            Class<?> mockMethodType = mockMethod.getReturnType();
            Class<?>[] mockMethodParameters = mockMethod.getParameterTypes();
            Class<?> originalMethodType = originalMethod.getReturnType();
            Class<?>[] originalMethodParameters = originalMethod.getParameterTypes();
            if (mockMethodType != originalMethodType) {
                throw BallerinaErrors.createError((String)"FunctionSignatureMismatchError", (String)"Return Types do not match");
            }
            if (mockMethodParameters.length != originalMethodParameters.length) {
                throw BallerinaErrors.createError((String)"FunctionSignatureMismatchError", (String)"Parameter types do not match");
            }
            for (int i = 0; i < mockMethodParameters.length; ++i) {
                if (mockMethodParameters[i] == originalMethodParameters[i]) continue;
                throw BallerinaErrors.createError((String)"FunctionSignatureMismatchError", (String)"Parameter types do not match");
            }
        } else {
            throw BallerinaErrors.createError((String)"FunctionNotFoundError", (String)("Mock function '" + mockMethodName + "' cannot be found"));
        }
    }

    private static Method getClassDeclaredMethod(String file, String methodName) throws ClassNotFoundException {
        String className = file.replace('/', '.').substring(0, file.length() - 6);
        Class<?> clazz = Class.forName(className);
        for (Method method : clazz.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static List<String> getCaseIds(ObjectValue mockObj, Object ... args) {
        ArrayList<String> caseIdList = new ArrayList<String>();
        StringBuilder caseId = new StringBuilder();
        caseId.append(mockObj.hashCode());
        caseIdList.add(caseId.toString());
        for (Object arg : args) {
            caseId.append("-");
            if (arg instanceof AbstractObjectValue || arg instanceof BRecordType) {
                caseId.append("__ANY__");
                continue;
            }
            caseId.append(arg);
        }
        if (!caseIdList.contains(caseId.toString())) {
            caseIdList.add(caseId.toString());
        }
        Collections.reverse(caseIdList);
        return caseIdList;
    }

    private static String formatFunctionPackage(String fnPackage) {
        fnPackage = fnPackage.replace('.', '_');
        fnPackage = fnPackage.replace('/', '.');
        fnPackage = fnPackage.replace(':', '.');
        return fnPackage;
    }
}

