/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.natives.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.AbstractObjectValue;
import org.ballerinalang.jvm.values.FutureValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.StringValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.testerina.natives.test.MockRegistry;

public class GenericMockObjectValue
extends AbstractObjectValue {
    private ObjectValue mockObj;

    public GenericMockObjectValue(BObjectType type, ObjectValue mockObj) {
        super(type);
        this.mockObj = mockObj;
    }

    public Object call(Strand strand, String funcName, Object ... args) {
        if (!this.mockObj.getType().getName().contains("$anonType$")) {
            return this.mockObj.call(strand, funcName, args);
        }
        List<String> caseIds = this.getCaseIds(this.mockObj, funcName, args);
        for (String caseId : caseIds) {
            if (!MockRegistry.getInstance().hasCase(caseId)) continue;
            String hitId = this.mockObj.hashCode() + "-" + funcName;
            if (MockRegistry.getInstance().hasHitCount(hitId)) {
                int currentHit = MockRegistry.getInstance().getMemberFuncHitsMap().get(hitId);
                MockRegistry.getInstance().getMemberFuncHitsMap().put(hitId, currentHit + 1);
            }
            return MockRegistry.getInstance().getReturnValue(caseId);
        }
        throw new BallerinaException("no cases registered for member function '" + funcName + "' of object type '" + this.mockObj.getType().getName() + "'.");
    }

    public Object get(BString fieldName) {
        if (!this.mockObj.getType().getName().contains("$anonType$")) {
            return this.mockObj.get(fieldName);
        }
        String caseId = this.getCaseIds(this.mockObj, fieldName.toString());
        if (MockRegistry.getInstance().hasCase(caseId)) {
            return MockRegistry.getInstance().getReturnValue(caseId);
        }
        throw new BallerinaException("no cases registered for member field '" + fieldName + "' of object type '" + this.mockObj.getType().getName() + "'.");
    }

    public ObjectValue getMockObj() {
        return this.mockObj;
    }

    private String getCaseIds(ObjectValue mockObj, String fieldName) {
        return mockObj.hashCode() + "-" + fieldName;
    }

    private List<String> getCaseIds(ObjectValue mockObj, String funcName, Object[] args) {
        ArrayList<String> caseIdList = new ArrayList<String>();
        StringBuilder caseId = new StringBuilder();
        args = this.removeUnnecessaryArgs(args);
        caseId.append(mockObj.hashCode()).append("-").append(funcName);
        caseIdList.add(caseId.toString());
        for (Object arg : args) {
            caseId.append("-");
            if (arg instanceof AbstractObjectValue || arg instanceof BRecordType) {
                caseId.append("__ANY__");
                continue;
            }
            caseId.append(arg);
        }
        caseIdList.add(caseId.toString());
        caseId.setLength(0);
        caseId.append(mockObj.hashCode()).append("-").append(funcName);
        for (Object arg : args) {
            caseId.append("-");
            if (arg instanceof AbstractObjectValue) {
                caseId.append("__ANY__");
                continue;
            }
            caseId.append(arg);
        }
        if (!caseIdList.contains(caseId.toString())) {
            caseIdList.add(caseId.toString());
        }
        caseId.setLength(0);
        caseId.append(mockObj.hashCode()).append("-").append(funcName);
        if (MockRegistry.getInstance().hasHitCount(caseId.toString())) {
            int hittingCount = MockRegistry.getInstance().getMemberFuncHitsMap().get(caseId.toString());
            caseId.append("-").append(hittingCount);
            caseIdList.add(caseId.toString());
        }
        Collections.reverse(caseIdList);
        return caseIdList;
    }

    private Object[] removeUnnecessaryArgs(Object[] args) {
        ArrayList<Object> newArgs = new ArrayList<Object>();
        for (int i = 0; i < args.length; i += 2) {
            if (args[i] == null) continue;
            newArgs.add(args[i]);
        }
        return newArgs.toArray();
    }

    public FutureValue start(Strand strand, String funcName, Object ... args) {
        return null;
    }

    public BString bStringValue() {
        return null;
    }

    public Object get(String fieldName) {
        if (!this.mockObj.getType().getName().contains("$anonType$")) {
            return this.mockObj.get(fieldName);
        }
        String caseId = this.getCaseIds(this.mockObj, fieldName);
        if (MockRegistry.getInstance().hasCase(caseId)) {
            return MockRegistry.getInstance().getReturnValue(caseId);
        }
        throw new BallerinaException("no cases registered for member field '" + fieldName + "' of object type '" + this.mockObj.getType().getName() + "'.");
    }

    public Object get(StringValue fieldName) {
        if (!this.mockObj.getType().getName().contains("$anonType$")) {
            return this.mockObj.get(fieldName);
        }
        String caseId = this.getCaseIds(this.mockObj, fieldName.toString());
        if (MockRegistry.getInstance().hasCase(caseId)) {
            return MockRegistry.getInstance().getReturnValue(caseId);
        }
        throw new BallerinaException("no cases registered for member field '" + fieldName + "' of object type '" + this.mockObj.getType().getName() + "'.");
    }

    public void set(String fieldName, Object value) {
    }

    public void set(StringValue fieldName, Object value) {
    }
}

