/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq.observability;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.util.Optional;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQObservabilityUtil;

public class RabbitMQTracingUtil {
    public static void traceResourceInvocation(Connection connection) {
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        RabbitMQTracingUtil.setTags(RabbitMQTracingUtil.getObserverContext(), connection);
    }

    public static void traceResourceInvocation(Channel channel) {
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        RabbitMQTracingUtil.setTags(RabbitMQTracingUtil.getObserverContext(), channel);
    }

    public static void traceQueueResourceInvocation(Channel channel, String queueName) {
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        ObserverContext observerContext = RabbitMQTracingUtil.getObserverContext();
        observerContext.addTag("queue", queueName);
        RabbitMQTracingUtil.setTags(observerContext, channel);
    }

    public static void traceExchangeResourceInvocation(Channel channel, String exchangeName) {
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        ObserverContext observerContext = RabbitMQTracingUtil.getObserverContext();
        observerContext.addTag("exchange", exchangeName);
        RabbitMQTracingUtil.setTags(observerContext, channel);
    }

    public static void traceQueueBindResourceInvocation(Channel channel, String queueName, String exchangeName, String routingKey) {
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        ObserverContext observerContext = RabbitMQTracingUtil.getObserverContext();
        observerContext.addTag("queue", queueName);
        observerContext.addTag("exchange", exchangeName);
        observerContext.addTag("routing_key", routingKey);
        RabbitMQTracingUtil.setTags(observerContext, channel);
    }

    public static void tracePublishResourceInvocation(Channel channel, String exchangeName, String routingKey) {
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        ObserverContext observerContext = RabbitMQTracingUtil.getObserverContext();
        observerContext.addTag("exchange", exchangeName);
        observerContext.addTag("routing_key", routingKey);
        RabbitMQTracingUtil.setTags(observerContext, channel);
    }

    private static ObserverContext getObserverContext() {
        ObserverContext observerContext;
        Strand strand = Scheduler.getStrand();
        Optional observerContextOptional = ObserveUtils.getObserverContextOfCurrentFrame((Strand)strand);
        if (observerContextOptional.isPresent()) {
            observerContext = (ObserverContext)observerContextOptional.get();
        } else {
            observerContext = new ObserverContext();
            ObserveUtils.setObserverContextToCurrentFrame((Strand)strand, (ObserverContext)observerContext);
        }
        return observerContext;
    }

    private static void setTags(ObserverContext observerContext, Connection connection) {
        observerContext.addTag("url", RabbitMQObservabilityUtil.getServerUrl(connection));
    }

    private static void setTags(ObserverContext observerContext, Channel channel) {
        RabbitMQTracingUtil.setTags(observerContext, channel.getConnection());
        observerContext.addTag("channel", channel.toString());
    }

    private RabbitMQTracingUtil() {
    }
}

