/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq.util;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.messaging.rabbitmq.RabbitMQUtils;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQMetricsUtil;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQTracingUtil;

public class MessageUtils {
    public static Object basicAck(Channel channel, int deliveryTag, boolean ackMode, boolean ackStatus, boolean multiple) {
        if (ackStatus) {
            return RabbitMQUtils.returnErrorValue("Trying to acknowledge the same message multiple times");
        }
        if (ackMode) {
            return RabbitMQUtils.returnErrorValue("Trying to acknowledge messages in auto-ack mode");
        }
        try {
            channel.basicAck((long)deliveryTag, multiple);
            RabbitMQMetricsUtil.reportAcknowledgement(channel, "ack");
            RabbitMQTracingUtil.traceResourceInvocation(channel);
        }
        catch (IOException exception) {
            RabbitMQMetricsUtil.reportError(channel, "ack");
            return RabbitMQUtils.returnErrorValue("Error occurred while positively acknowledging the message: " + exception.getMessage());
        }
        catch (AlreadyClosedException exception) {
            RabbitMQMetricsUtil.reportError(channel, "ack");
            return RabbitMQUtils.returnErrorValue("Channel already closed, messages will no longer be received: ");
        }
        return null;
    }

    public static Object basicNack(Channel channel, int deliveryTag, boolean ackMode, boolean ackStatus, boolean multiple, boolean requeue) {
        if (ackStatus) {
            RabbitMQMetricsUtil.reportError(channel, "nack");
            return RabbitMQUtils.returnErrorValue("Trying to acknowledge the same message multiple times");
        }
        if (ackMode) {
            RabbitMQMetricsUtil.reportError(channel, "nack");
            return RabbitMQUtils.returnErrorValue("Trying to acknowledge messages in auto-ack mode");
        }
        try {
            channel.basicNack((long)deliveryTag, multiple, requeue);
            RabbitMQMetricsUtil.reportAcknowledgement(channel, "nack");
            RabbitMQTracingUtil.traceResourceInvocation(channel);
        }
        catch (IOException exception) {
            RabbitMQMetricsUtil.reportError(channel, "nack");
            return RabbitMQUtils.returnErrorValue("Error occurred while negatively acknowledging the message: " + exception.getMessage());
        }
        catch (AlreadyClosedException exception) {
            RabbitMQMetricsUtil.reportError(channel, "nack");
            return RabbitMQUtils.returnErrorValue("Channel already closed, messages will no longer be received: ");
        }
        return null;
    }

    public static Object getTextContent(ArrayValue messageContent) {
        byte[] messageCont = messageContent.getBytes();
        try {
            return new String(messageCont, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException exception) {
            RabbitMQMetricsUtil.reportError("get_message_content");
            return RabbitMQUtils.returnErrorValue("Error while retrieving the string content of the message. " + exception.getMessage());
        }
    }

    public static Object getFloatContent(ArrayValue messageContent) {
        try {
            return Double.parseDouble(new String(messageContent.getBytes(), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException exception) {
            RabbitMQMetricsUtil.reportError("get_message_content");
            return RabbitMQUtils.returnErrorValue("Error while retrieving the float content of the message. " + exception.getMessage());
        }
    }

    public static Object getIntContent(ArrayValue messageContent) {
        try {
            return Integer.parseInt(new String(messageContent.getBytes(), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException exception) {
            RabbitMQMetricsUtil.reportError("get_message_content");
            return RabbitMQUtils.returnErrorValue("Error while retrieving the int content of the message. " + exception.getMessage());
        }
    }

    public static Object getJSONContent(ArrayValue messageContent) {
        try {
            Object json = JSONParser.parse((String)new String(messageContent.getBytes(), StandardCharsets.UTF_8.name()));
            if (json instanceof String) {
                return StringUtils.fromString((String)((String)json));
            }
            return json;
        }
        catch (UnsupportedEncodingException exception) {
            RabbitMQMetricsUtil.reportError("get_message_content");
            return RabbitMQUtils.returnErrorValue("Error while retrieving the json content of the message. " + exception.getMessage());
        }
    }

    public static Object getXMLContent(ArrayValue messageContent) {
        try {
            return XMLFactory.parse((String)new String(messageContent.getBytes(), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException exception) {
            RabbitMQMetricsUtil.reportError("get_message_content");
            return RabbitMQUtils.returnErrorValue("Error while retrieving the xml content of the message. " + exception.getMessage());
        }
    }

    private MessageUtils() {
    }
}

