/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.docker.generator.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinax.docker.generator.exceptions.DockerGenException;

public class DockerImageName {
    private static final String nameComponentRegexp = "[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?";
    private static final String domainComponentRegexp = "(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])";
    private final Pattern nameComponentPattern = Pattern.compile("[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?");
    private final Pattern imageNamePattern = Pattern.compile("[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?(?:(?:/[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?)+)?");
    private final Pattern domainPattern = Pattern.compile("^(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))*(?::[0-9]+)?$");
    private final Pattern tagPattern = Pattern.compile("^[\\w][\\w.-]{0,127}$");
    private final Pattern digestPattern = Pattern.compile("^sha256:[a-z0-9]{32,}$");
    private String repository;
    private String registry;
    private String tag;
    private String digest;
    private String user;

    private DockerImageName(String fullName) {
        this(fullName, null);
    }

    private DockerImageName(String fullName, String givenTag) {
        Pattern tagPattern;
        Matcher matcher;
        if (fullName == null) {
            throw new NullPointerException("image name must not be null");
        }
        this.digest = null;
        if (fullName.contains("@sha256")) {
            String[] digestParts = fullName.split("@");
            this.digest = digestParts[1];
            fullName = digestParts[0];
        }
        if (!(matcher = (tagPattern = Pattern.compile("^(.+?)(?::([^:/]+))?$")).matcher(fullName)).matches()) {
            throw new IllegalArgumentException(fullName + " is not a proper image name ([registry/][repo][:port]");
        }
        this.tag = givenTag != null ? givenTag : matcher.group(2);
        String rest = matcher.group(1);
        this.parseComponentsBeforeTag(rest);
        if (this.tag == null && this.digest == null) {
            this.tag = "latest";
        }
        this.doValidate();
    }

    public static DockerImageName parseName(String imageName) throws DockerGenException {
        try {
            return new DockerImageName(imageName);
        }
        catch (IllegalArgumentException iaEx) {
            throw new DockerGenException(iaEx.getMessage());
        }
    }

    public static void validate(String imageName) throws DockerGenException {
        DockerImageName.parseName(imageName);
    }

    public String getRepository() {
        return this.repository;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDigest() {
        return this.digest;
    }

    public boolean hasRegistry() {
        return this.registry != null && this.registry.length() > 0;
    }

    private String joinTail(String[] parts) {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i >= parts.length - 1) continue;
            builder.append("/");
        }
        return builder.toString();
    }

    private boolean isRegistry(String part) {
        return part.contains(".") || part.contains(":");
    }

    public String getNameWithoutTag() {
        return this.getNameWithoutTag(null);
    }

    public String getNameWithoutTag(String optionalRegistry) {
        StringBuilder ret = new StringBuilder();
        if (this.registry != null || optionalRegistry != null) {
            ret.append(this.registry != null ? this.registry : optionalRegistry).append("/");
        }
        ret.append(this.repository);
        return ret.toString();
    }

    public String getFullName() {
        return this.getFullName(null);
    }

    public String getFullName(String optionalRegistry) {
        String fullName = this.getNameWithoutTag(optionalRegistry);
        if (this.tag != null) {
            fullName = fullName + ":" + this.tag;
        }
        if (this.digest != null) {
            fullName = fullName + "@" + this.digest;
        }
        return fullName;
    }

    public String getUser() {
        return this.user;
    }

    public String getSimpleName() {
        String prefix = this.user + "/";
        return this.repository.startsWith(prefix) ? this.repository.substring(prefix.length()) : this.repository;
    }

    private void doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        String image = this.user != null ? this.repository.substring(this.user.length() + 1) : this.repository;
        Object[] checks = new Object[]{"registry url", this.domainPattern, this.registry, "image name", this.imageNamePattern, image, "user", this.nameComponentPattern, this.user, "tag", this.tagPattern, this.tag, "digest", this.digestPattern, this.digest};
        for (int i = 0; i < checks.length; i += 3) {
            String value = (String)checks[i + 2];
            Pattern checkPattern = (Pattern)checks[i + 1];
            if (value == null || checkPattern.matcher(value).matches()) continue;
            errors.add(checks[i] + " '" + value + "' is invalid");
        }
        if (errors.size() > 0) {
            String buf = "given docker name '" + this.getFullName() + "' is invalid: " + (String)errors.get(0);
            throw new IllegalArgumentException(buf);
        }
    }

    private void parseComponentsBeforeTag(String rest) {
        String[] parts = rest.split("\\s*/\\s*");
        if (parts.length == 1) {
            this.registry = null;
            this.user = null;
            this.repository = parts[0];
        } else if (parts.length >= 2) {
            if (this.isRegistry(parts[0])) {
                this.registry = parts[0];
                if (parts.length > 2) {
                    this.user = parts[1];
                    this.repository = this.joinTail(parts);
                } else {
                    this.user = null;
                    this.repository = parts[1];
                }
            } else {
                this.registry = null;
                this.user = parts[0];
                this.repository = rest;
            }
        }
    }
}

