/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.classwriter;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.nativeimpl.jvm.ASMUtil;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.objectweb.asm.ClassTooLargeException;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodTooLargeException;

@BallerinaFunction(orgName="ballerina", packageName="jvm", functionName="toByteArray", receiver=@Receiver(type=TypeKind.OBJECT, structType="ClassWriter", structPackage="ballerina/jvm"), returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.BYTE)})
public class ToByteArray {
    private static final String NAME = "name";

    public static Object toByteArray(Strand strand, ObjectValue oCw) {
        ClassWriter cw = (ClassWriter)ASMUtil.getRefArgumentNativeData(oCw);
        try {
            return new ArrayValueImpl(cw.toByteArray());
        }
        catch (MethodTooLargeException e) {
            MapValueImpl details = new MapValueImpl((BType)BTypes.typeErrorDetail);
            details.put((Object)NAME, (Object)e.getMethodName());
            return BallerinaErrors.createError((String)"MethodTooLarge", (MapValue)details);
        }
        catch (ClassTooLargeException e) {
            MapValueImpl details = new MapValueImpl((BType)BTypes.typeErrorDetail);
            details.put((Object)NAME, (Object)e.getClassName());
            return BallerinaErrors.createError((String)"ClassTooLarge", (MapValue)details);
        }
        catch (Exception e) {
            return BallerinaErrors.createError((String)e.getMessage());
        }
    }
}

