/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.methodvisitor;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.nativeimpl.jvm.ASMUtil;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.objectweb.asm.MethodVisitor;

@BallerinaFunction(orgName="ballerina", packageName="jvm", functionName="visitLdcInsn", receiver=@Receiver(type=TypeKind.OBJECT, structType="MethodVisitor", structPackage="ballerina/jvm"), args={@Argument(name="value", type=TypeKind.ANY)})
public class VisitLdcInsn {
    public static void visitLdcInsn(Strand strand, ObjectValue oMv, Object oValue) {
        MethodVisitor mv = (MethodVisitor)ASMUtil.getRefArgumentNativeData(oMv);
        if (Long.class.equals(oValue.getClass())) {
            long longVal = (Long)oValue;
            mv.visitLdcInsn((Object)longVal);
        } else if (Double.class.equals(oValue.getClass())) {
            double doubleVal = (Double)oValue;
            mv.visitLdcInsn((Object)doubleVal);
        } else if (String.class.equals(oValue.getClass())) {
            String stringVal = (String)oValue;
            mv.visitLdcInsn((Object)stringVal);
        } else if (Boolean.class.equals(oValue.getClass())) {
            boolean booleanValue = (Boolean)oValue;
            mv.visitLdcInsn((Object)booleanValue);
        } else if (Integer.class.equals(oValue.getClass())) {
            int intVal = (Integer)oValue;
            mv.visitLdcInsn((Object)intVal);
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

