/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.tests;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.BmpStringValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.StringValue;
import org.ballerinalang.jvm.values.TupleValueImpl;
import org.ballerinalang.jvm.values.api.BDecimal;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.nativeimpl.jvm.tests.JavaInteropTestCheckedException;

public class StaticMethods {
    private static final BArrayType intArrayType = new BArrayType(BTypes.typeInt);
    private static final BArrayType jsonArrayType = new BArrayType(BTypes.typeJSON);
    private static final BTupleType tupleType = new BTupleType(Arrays.asList(BTypes.typeInt, BTypes.typeFloat, BTypes.typeString, BTypes.typeInt, BTypes.typeString));

    private StaticMethods() {
    }

    public static void acceptNothingAndReturnNothing() {
    }

    public static Date acceptNothingButReturnDate() {
        return new Date();
    }

    public static StringValue acceptNothingButReturnString() {
        return new BmpStringValue("hello world");
    }

    public static BString stringParamAndReturn(BString a1) {
        return a1.concat((BString)new BmpStringValue(" and Hadrian"));
    }

    public static Date acceptSomethingAndReturnSomething(Date date) {
        return date;
    }

    public static String acceptTwoParamsAndReturnSomething(String s1, String s2) {
        return s1 + s2;
    }

    public static Integer acceptThreeParamsAndReturnSomething(Integer s1, Integer s2, Integer s3) {
        return s1 + s2 + s3;
    }

    public static ArrayValue getArrayValueFromMap(String key, MapValue mapValue) {
        ArrayValue arrayValue = (ArrayValue)BValueCreator.createArrayValue((BArrayType)intArrayType);
        arrayValue.add(0L, 1L);
        long fromMap = mapValue.getIntValue(key);
        arrayValue.add(1L, fromMap);
        return arrayValue;
    }

    public static MapValue acceptRefTypesAndReturnMap(ObjectValue a, ArrayValue b, Object c, ErrorValue d, Object e, Object f, MapValue g) {
        MapValueImpl mapValue = new MapValueImpl();
        mapValue.put((Object)"a", (Object)a);
        mapValue.put((Object)"b", (Object)b);
        mapValue.put((Object)"c", c);
        mapValue.put((Object)"e", e);
        mapValue.put((Object)"f", f);
        mapValue.put((Object)"g", (Object)g);
        return mapValue;
    }

    public static boolean acceptServiceObjectAndReturnBoolean(ObjectValue serviceObject) {
        return 19 == serviceObject.getType().getTag();
    }

    public static ErrorValue acceptStringErrorReturn(String msg) {
        return new ErrorValue(msg, (Object)new MapValueImpl((BType)BTypes.typeErrorDetail));
    }

    public static Object acceptIntUnionReturn(int flag) {
        switch (flag) {
            case 1: {
                return 25;
            }
            case 2: {
                return "sample value return";
            }
            case 3: {
                return 54.88;
            }
        }
        return true;
    }

    public static ObjectValue acceptObjectAndObjectReturn(ObjectValue p, int newVal) {
        p.set("age", (Object)newVal);
        return p;
    }

    public static MapValue acceptRecordAndRecordReturn(MapValue e, String newVal) {
        e.put((Object)"name", (Object)newVal);
        return e;
    }

    public static String getString(UUID uuid) {
        return uuid.toString() + ": Sameera";
    }

    public static void acceptNothingReturnNothingAndThrowsCheckedException() throws JavaInteropTestCheckedException {
    }

    public static void acceptNothingReturnNothingAndThrowsMultipleCheckedException() throws JavaInteropTestCheckedException, IOException, ClassNotFoundException {
    }

    public static void acceptNothingReturnNothingAndThrowsUncheckedException() throws UnsupportedOperationException {
    }

    public static void acceptNothingReturnNothingAndThrowsCheckedAndUncheckedException() throws JavaInteropTestCheckedException, UnsupportedOperationException, ClassNotFoundException {
    }

    public static Date acceptNothingReturnSomethingAndThrowsCheckedException() throws JavaInteropTestCheckedException {
        return new Date();
    }

    public static Date acceptNothingReturnSomethingAndThrowsMultipleCheckedException() throws JavaInteropTestCheckedException, IOException, ClassNotFoundException {
        return new Date();
    }

    public static Date acceptNothingReturnSomethingAndThrowsUncheckedException() throws UnsupportedOperationException {
        return new Date();
    }

    public static Date acceptNothingReturnSomethingAndThrowsCheckedAndUncheckedException() throws JavaInteropTestCheckedException, UnsupportedOperationException, ClassNotFoundException {
        return new Date();
    }

    public static Date acceptSomethingReturnSomethingAndThrowsCheckedAndUncheckedException(Date date) throws JavaInteropTestCheckedException, UnsupportedOperationException, ClassNotFoundException {
        return date;
    }

    public static Date acceptSomethingReturnSomethingAndThrowsCheckedException(Date date) throws JavaInteropTestCheckedException {
        return date;
    }

    public static Date acceptSomethingReturnSomethingAndThrowsMultipleCheckedException(Date date) throws JavaInteropTestCheckedException, IOException, ClassNotFoundException {
        return date;
    }

    public static Date acceptSomethingReturnSomethingAndThrowsUncheckedException(Date date) throws UnsupportedOperationException {
        return date;
    }

    public static int acceptIntReturnIntThrowsCheckedException(long a) throws JavaInteropTestCheckedException {
        return (int)(a + 5L);
    }

    public static ArrayValue getArrayValueFromMapWhichThrowsCheckedException(String key, MapValue mapValue) throws JavaInteropTestCheckedException {
        ArrayValue arrayValue = (ArrayValue)BValueCreator.createArrayValue((BArrayType)intArrayType);
        arrayValue.add(0L, 1L);
        long fromMap = mapValue.getIntValue(key);
        arrayValue.add(1L, fromMap);
        return arrayValue;
    }

    public static MapValue acceptRefTypesAndReturnMapWhichThrowsCheckedException(ObjectValue a, ArrayValue b, Object c, ErrorValue d, Object e, Object f, MapValue g) throws JavaInteropTestCheckedException {
        MapValueImpl mapValue = new MapValueImpl();
        mapValue.put((Object)"a", (Object)a);
        mapValue.put((Object)"b", (Object)b);
        mapValue.put((Object)"c", c);
        mapValue.put((Object)"e", e);
        mapValue.put((Object)"f", f);
        mapValue.put((Object)"g", (Object)g);
        return mapValue;
    }

    public static ErrorValue acceptStringErrorReturnWhichThrowsCheckedException(String msg) throws JavaInteropTestCheckedException {
        return new ErrorValue(msg, (Object)new MapValueImpl((BType)BTypes.typeErrorDetail));
    }

    public static Object acceptIntUnionReturnWhichThrowsCheckedException(int flag) throws JavaInteropTestCheckedException {
        switch (flag) {
            case 1: {
                return 25;
            }
            case 2: {
                return "sample value return";
            }
            case 3: {
                return 54.88;
            }
        }
        return true;
    }

    public static ObjectValue acceptObjectAndObjectReturnWhichThrowsCheckedException(ObjectValue p, int newVal) throws JavaInteropTestCheckedException {
        p.set("age", (Object)newVal);
        return p;
    }

    public static MapValue acceptRecordAndRecordReturnWhichThrowsCheckedException(MapValue e, String newVal) throws JavaInteropTestCheckedException {
        e.put((Object)"name", (Object)newVal);
        return e;
    }

    public static MapValue getMapOrError(String swaggerFilePath, MapValue apiDef) throws JavaInteropTestCheckedException {
        String finalBasePath = "basePath";
        AtomicLong runCount = new AtomicLong(0L);
        ArrayValueImpl arrayValue = new ArrayValueImpl(new BArrayType(BallerinaValues.createRecordValue((BPackage)new BPackage("", "."), (String)"ResourceDefinition").getType()));
        MapValue apiDefinitions = BallerinaValues.createRecordValue((BPackage)new BPackage("", "."), (String)"ApiDefinition");
        MapValue resource = BallerinaValues.createRecordValue((BPackage)new BPackage("", "."), (String)"ResourceDefinition");
        resource.put((Object)"path", (Object)finalBasePath);
        resource.put((Object)"method", (Object)"Method string");
        arrayValue.add(runCount.getAndIncrement(), (Object)resource);
        apiDefinitions.put((Object)"resources", (Object)arrayValue);
        return apiDefinitions;
    }

    public static TupleValueImpl getArrayValue() throws BallerinaException {
        Object name = null;
        Object type = null;
        try {
            return new TupleValueImpl((Object[])new String[]{name, type}, new BTupleType((List)new ArrayList<BType>(){
                {
                    this.add(BTypes.typeString);
                    this.add(BTypes.typeString);
                }
            }));
        }
        catch (BallerinaException e) {
            throw new BallerinaException("Error occurred while creating ArrayValue.", (Throwable)e);
        }
    }

    public static long funcWithAsyncDefaultParamExpression(long a, long b) {
        return a + b * 2L;
    }

    public static long usingParamValues(long a, long b) {
        return a + b * 3L;
    }

    public static BDecimal decimalParamAndReturn(BDecimal a) {
        return new DecimalValue(new BigDecimal("99.7")).add(a);
    }

    public static Object decimalParamAndReturnAsObject(BDecimal a) {
        return new DecimalValue(new BigDecimal("99.6")).add(a);
    }

    public static BDecimal decimalParamAndWithBigDecimal(BigDecimal a) {
        return new DecimalValue(new BigDecimal("99.6")).add(new DecimalValue(a));
    }

    public static BDecimal decimalParamAsObjectAndReturn(Object a) {
        return new DecimalValue(new BigDecimal("99.4").add((BigDecimal)a));
    }

    public static String returnStringForBUnionFromJava() {
        return "99999";
    }

    public static TupleValueImpl mockedNativeFuncWithOptionalParams(long a, double b, String c, long d, String e) {
        TupleValueImpl tuple = (TupleValueImpl)BValueCreator.createTupleValue((BTupleType)tupleType);
        tuple.add(0L, (Object)a);
        tuple.add(1L, (Object)b);
        tuple.add(2L, (Object)c);
        tuple.add(3L, (Object)d);
        tuple.add(4L, (Object)e);
        return tuple;
    }

    public static UUID getUUId() {
        UUID uuid = UUID.randomUUID();
        return uuid;
    }

    public static Object getJson() {
        MapValueImpl map = new MapValueImpl(BTypes.typeJSON);
        map.put((Object)"name", (Object)"John");
        return map;
    }

    public static MapValueImpl getJsonObject() {
        MapValueImpl map = new MapValueImpl(BTypes.typeJSON);
        map.put((Object)"name", (Object)"Doe");
        return map;
    }

    public static ArrayValue getJsonArray() {
        ArrayValue array = (ArrayValue)BValueCreator.createArrayValue((BArrayType)jsonArrayType);
        array.add(0L, (Object)"John");
        return array;
    }

    public static Object getNullJson() {
        return null;
    }

    public static int getInt() {
        return 4;
    }

    public static int getIntFromJson(Object json) {
        return ((Number)json).intValue();
    }

    public static int getIntFromJsonInt(int json) {
        return json;
    }
}

