/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler;

public class EitherPair<L, R> {
    private final L left;
    private final R right;

    public static <L, R> EitherPair<L, R> forLeft(L left) {
        return new EitherPair<L, Object>(left, null);
    }

    public static <L, R> EitherPair<L, R> forRight(R right) {
        return new EitherPair<Object, R>(null, right);
    }

    protected EitherPair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public Object get() {
        if (this.left != null) {
            return this.left;
        }
        return this.right;
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EitherPair)) {
            return false;
        }
        EitherPair other = (EitherPair)obj;
        return this.left == other.left && this.right == other.right || this.left != null && other.left != null && this.left.equals(other.left) || this.right != null && other.right != null && this.right.equals(other.right);
    }

    public int hashCode() {
        if (this.left != null) {
            return this.left.hashCode();
        }
        return this.right != null ? this.right.hashCode() : 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("EitherPair [").append(System.lineSeparator());
        builder.append("  left = ").append(this.left).append(System.lineSeparator());
        builder.append("  right = ").append(this.right).append(System.lineSeparator());
        return builder.append("]").toString();
    }
}

