/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.CollectDiagnosticListener;
import org.ballerinalang.langserver.compiler.LSClientLogger;
import org.ballerinalang.langserver.compiler.LSPackageCache;
import org.ballerinalang.langserver.compiler.workspace.WorkspaceDocumentManagerImpl;
import org.ballerinalang.langserver.compiler.workspace.repository.LSPathConverter;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompiledPackage;
import org.ballerinalang.util.diagnostic.DiagnosticListener;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public class LSContextManager {
    private static final LSContextManager INSTANCE = new LSContextManager();
    private static final String BUILT_IN_PACKAGES_PROJ_DIR = "$builtInPackagesProjectDir";
    private static final int MAX_COMPILATION_COUNT = 200;
    private static volatile int compilationCounter = 0;
    private final Map<String, CompilerContext> contextMap = new ConcurrentHashMap<String, CompilerContext>();

    public static LSContextManager getInstance() {
        return INSTANCE;
    }

    private LSContextManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public CompilerContext getCompilerContext(@Nullable PackageID packageID, String projectDir, WorkspaceDocumentManager documentManager) {
        CompilerContext compilerContext = this.contextMap.get(projectDir);
        if (compilationCounter > 200) {
            compilerContext = null;
            compilationCounter = 0;
            LSClientLogger.logTrace("CompilationContext for {projectRoot: '" + projectDir + "'}, has been reinitialized");
        }
        if (compilerContext == null) {
            Class<LSContextManager> clazz = LSContextManager.class;
            // MONITORENTER : org.ballerinalang.langserver.compiler.LSContextManager.class
            compilerContext = this.contextMap.get(projectDir);
            if (compilerContext == null) {
                compilerContext = this.createNewCompilerContext(projectDir, documentManager);
                this.contextMap.put(projectDir, compilerContext);
            }
            // MONITOREXIT : clazz
        }
        LSContextManager.clearCurrentPackage(packageID, compilerContext);
        ++compilationCounter;
        return compilerContext;
    }

    public void setCompilerContext(String projectDir, CompilerContext compilerContext) {
        this.contextMap.put(projectDir, compilerContext);
    }

    public void removeCompilerContext(String projectDir) {
        this.contextMap.remove(projectDir);
    }

    public void clearAllContexts() {
        this.contextMap.clear();
    }

    public CompilerContext getBuiltInPackagesCompilerContext() {
        return this.getCompilerContext(null, BUILT_IN_PACKAGES_PROJ_DIR, WorkspaceDocumentManagerImpl.getInstance());
    }

    public CompilerContext createNewCompilerContext(String projectDir, WorkspaceDocumentManager documentManager) {
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, projectDir);
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.DESUGAR.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, Boolean.toString(true));
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(true));
        context.put(SourceDirectory.class, (Object)new NullSourceDirectory(Paths.get(projectDir, new String[0]), documentManager));
        CollectDiagnosticListener diagnosticListener = new CollectDiagnosticListener();
        context.put(DiagnosticListener.class, (Object)diagnosticListener);
        return context;
    }

    private static void clearCurrentPackage(@Nullable PackageID packageID, CompilerContext context) {
        LSPackageCache instance = LSPackageCache.getInstance(context);
        if (packageID != null) {
            instance.invalidate(packageID);
        }
        PackageCache.setInstance((PackageCache)instance.getPackageCache(), (CompilerContext)context);
    }

    public static class NullSourceDirectory
    implements SourceDirectory {
        private final Path projectDir;
        private final WorkspaceDocumentManager documentManager;

        public NullSourceDirectory(Path projectDir, WorkspaceDocumentManager documentManager) {
            this.projectDir = projectDir;
            this.documentManager = documentManager;
        }

        public boolean canHandle(Path dirPath) {
            return true;
        }

        public Path getPath() {
            return null;
        }

        public List<String> getSourceFileNames() {
            return Collections.emptyList();
        }

        public List<String> getSourcePackageNames() {
            return Collections.emptyList();
        }

        public InputStream getManifestContent() {
            return new ByteArrayInputStream("".getBytes(Charset.defaultCharset()));
        }

        public InputStream getLockFileContent() {
            return new ByteArrayInputStream("".getBytes(Charset.defaultCharset()));
        }

        public Path saveCompiledProgram(InputStream source, String fileName) {
            return null;
        }

        public void saveCompiledPackage(CompiledPackage compiledPackage, Path dirPath, String fileName) throws IOException {
        }

        public Converter<Path> getConverter() {
            return new LSPathConverter(this.projectDir, this.documentManager);
        }
    }
}

