/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSClientLogger;
import org.ballerinalang.langserver.compiler.LSCompilerCache;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;
import org.ballerinalang.langserver.compiler.LSPackageCache;
import org.ballerinalang.langserver.compiler.common.LSDocumentIdentifierImpl;
import org.ballerinalang.langserver.compiler.config.LSClientConfig;
import org.ballerinalang.langserver.compiler.config.LSClientConfigHolder;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.compiler.workspace.repository.WorkspacePackageRepository;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.PackageRepository;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class LSModuleCompiler {
    protected LSModuleCompiler() {
    }

    public static BLangPackage getBLangPackage(LSContext context, WorkspaceDocumentManager docManager, Class<? extends ANTLRErrorStrategy> errStrategy, boolean compileFullProject, boolean stopOnSemanticErrors) throws CompilationFailedException {
        List<BLangPackage> bLangPackages = LSModuleCompiler.getBLangPackages(context, docManager, errStrategy, compileFullProject, false, stopOnSemanticErrors);
        return bLangPackages.get(0);
    }

    public static List<BLangPackage> getBLangModules(LSContext context, WorkspaceDocumentManager docManager, Class<? extends ANTLRErrorStrategy> errStrategy, boolean stopOnSemanticErrors) throws URISyntaxException, CompilationFailedException {
        String sourceRoot = Paths.get(new URI((String)context.get(DocumentServiceKeys.SOURCE_ROOT_KEY))).toString();
        WorkspacePackageRepository pkgRepo = new WorkspacePackageRepository(sourceRoot, docManager);
        CompilerContext compilerContext = LSCompilerUtil.prepareCompilerContext((PackageRepository)pkgRepo, sourceRoot, docManager, stopOnSemanticErrors);
        Compiler compiler = LSCompilerUtil.getCompiler(context, compilerContext, errStrategy);
        return LSModuleCompiler.compilePackagesSafe(compiler, sourceRoot, false, context);
    }

    public static List<BLangPackage> getBLangPackages(LSContext context, WorkspaceDocumentManager docManager, Class<? extends ANTLRErrorStrategy> errStrategy, boolean compileFullProject, boolean clearProjectModules, boolean stopOnSemanticErrors) throws CompilationFailedException {
        Compiler compiler;
        PackageID pkgID;
        String relativeFilePath;
        String uri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
        Optional<String> unsavedFileId = LSCompilerUtil.getUntitledFileId(uri);
        if (unsavedFileId.isPresent()) {
            uri = LSCompilerUtil.createTempFile(unsavedFileId.get()).toUri().toString();
            context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)uri);
        }
        LSDocumentIdentifierImpl sourceDoc = new LSDocumentIdentifierImpl(uri);
        context.put(DocumentServiceKeys.LS_DOCUMENT_KEY, (Object)sourceDoc);
        String projectRoot = sourceDoc.getProjectRoot();
        WorkspacePackageRepository pkgRepo = new WorkspacePackageRepository(projectRoot, docManager);
        ArrayList<BLangPackage> packages = new ArrayList<BLangPackage>();
        String pkgName = sourceDoc.getOwnerModule();
        if (pkgName.isEmpty()) {
            Path fileNamePath = sourceDoc.getPath().getFileName();
            relativeFilePath = fileNamePath == null ? "" : fileNamePath.toString();
            pkgID = new PackageID(relativeFilePath);
            pkgName = relativeFilePath;
            compileFullProject = false;
        } else {
            relativeFilePath = sourceDoc.getProjectRootPath().resolve("src").resolve(pkgName).relativize(sourceDoc.getPath()).toString();
            pkgID = LSModuleCompiler.generatePackageFromManifest(pkgName, projectRoot);
        }
        context.put(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY, (Object)relativeFilePath);
        CompilerContext compilerContext = LSCompilerUtil.prepareCompilerContext(pkgID, (PackageRepository)pkgRepo, sourceDoc, docManager, stopOnSemanticErrors);
        context.put(DocumentServiceKeys.SOURCE_ROOT_KEY, (Object)projectRoot);
        context.put(DocumentServiceKeys.CURRENT_PKG_NAME_KEY, (Object)pkgID.getNameComps().stream().map(Name::getValue).collect(Collectors.joining(".")));
        if (compileFullProject && !projectRoot.isEmpty() && sourceDoc.isWithinProject()) {
            if (clearProjectModules) {
                LSPackageCache.getInstance(compilerContext).invalidateProjectModules(sourceDoc.getProjectModules());
            }
            compiler = LSCompilerUtil.getCompiler(context, compilerContext, errStrategy);
            List<BLangPackage> projectPackages = LSModuleCompiler.compilePackagesSafe(compiler, projectRoot, false, context);
            packages.addAll(projectPackages);
            Optional<BLangPackage> currentPkg = projectPackages.stream().filter(bLangPackage -> {
                String name = bLangPackage.packageID.nameComps.stream().map(Name::getValue).collect(Collectors.joining("."));
                return ((String)context.get(DocumentServiceKeys.CURRENT_PKG_NAME_KEY)).equals(name);
            }).findAny();
            LSPackageCache.getInstance(compilerContext).invalidate(currentPkg.get().packageID);
        } else {
            compiler = LSCompilerUtil.getCompiler(context, compilerContext, errStrategy);
            BLangPackage bLangPackage2 = LSModuleCompiler.compileSafe(compiler, projectRoot, pkgName, context);
            LSPackageCache.getInstance(compilerContext).invalidate(bLangPackage2.packageID);
            packages.add(bLangPackage2);
        }
        if (packages.isEmpty()) {
            throw new CompilationFailedException("Couldn't find any compiled artifact!");
        }
        Optional<BLangPackage> currentPackage = LSModuleCompiler.filterCurrentPackage(packages, context);
        currentPackage.ifPresent(bLangPackage -> {
            context.put(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY, bLangPackage);
            context.put(DocumentServiceKeys.CURRENT_PACKAGE_ID_KEY, (Object)bLangPackage.packageID);
        });
        return packages;
    }

    protected static BLangPackage compileSafe(Compiler compiler, String projectRoot, String pkgName, LSContext context) throws CompilationFailedException {
        LSCompilerCache.Key key = new LSCompilerCache.Key(projectRoot, context);
        LSClientConfig config = LSClientConfigHolder.getInstance().getConfig();
        try {
            BLangPackage bLangPackage;
            boolean isOutdatedSupported;
            long startTime = 0L;
            if (config.isTraceLogEnabled()) {
                startTime = System.nanoTime();
            }
            boolean isCacheSupported = context.get(DocumentServiceKeys.IS_CACHE_SUPPORTED) != null && (Boolean)context.get(DocumentServiceKeys.IS_CACHE_SUPPORTED) != false;
            boolean bl = isOutdatedSupported = context.get(DocumentServiceKeys.IS_CACHE_OUTDATED_SUPPORTED) != null && (Boolean)context.get(DocumentServiceKeys.IS_CACHE_OUTDATED_SUPPORTED) != false;
            if (isCacheSupported) {
                LSCompilerCache.CacheEntry cacheEntry = LSCompilerCache.getPackage(key, context);
                if (cacheEntry != null && (isOutdatedSupported || !cacheEntry.isOutdated())) {
                    if (config.isTraceLogEnabled()) {
                        long endTime = System.nanoTime();
                        long eTime = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
                        LSClientLogger.logTrace("Operation '" + context.getOperation().getName() + "' {projectRoot: '" + projectRoot + "'}, served through cache within " + eTime + "ms");
                    }
                    return cacheEntry.get().getLeft();
                }
                bLangPackage = compiler.compile(pkgName);
                LSCompilerCache.putPackage(key, bLangPackage, context);
            } else {
                bLangPackage = compiler.compile(pkgName);
            }
            if (config.isTraceLogEnabled()) {
                long endTime = System.nanoTime();
                long eTime = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
                LSClientLogger.logTrace("Operation '" + context.getOperation().getName() + "' {projectRoot: '" + projectRoot + "'}, compilation took " + eTime + "ms");
            }
            return bLangPackage;
        }
        catch (RuntimeException e) {
            LSCompilerCache.markOutDated(key);
            throw new CompilationFailedException("Oh no, something really went wrong. Bad. Sad.", e);
        }
    }

    protected static List<BLangPackage> compilePackagesSafe(Compiler compiler, String projectRoot, boolean isBuild, LSContext context) throws CompilationFailedException {
        LSCompilerCache.Key key = new LSCompilerCache.Key(projectRoot, context);
        LSClientConfig config = LSClientConfigHolder.getInstance().getConfig();
        try {
            List bLangPackages;
            boolean isOutdatedSupported;
            long startTime = 0L;
            if (config.isTraceLogEnabled()) {
                startTime = System.nanoTime();
            }
            boolean isCacheSupported = context.get(DocumentServiceKeys.IS_CACHE_SUPPORTED) != null && (Boolean)context.get(DocumentServiceKeys.IS_CACHE_SUPPORTED) != false;
            boolean bl = isOutdatedSupported = context.get(DocumentServiceKeys.IS_CACHE_OUTDATED_SUPPORTED) != null && (Boolean)context.get(DocumentServiceKeys.IS_CACHE_OUTDATED_SUPPORTED) != false;
            if (isCacheSupported) {
                LSCompilerCache.CacheEntry cacheEntry = LSCompilerCache.getPackages(key, context);
                if (cacheEntry != null && (isOutdatedSupported || !cacheEntry.isOutdated())) {
                    if (config.isTraceLogEnabled()) {
                        long endTime = System.nanoTime();
                        long eTime = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
                        LSClientLogger.logTrace("Operation '" + context.getOperation().getName() + "' {projectRoot: '" + projectRoot + "'}, served through cache within " + eTime + "ms");
                    }
                    return cacheEntry.get().getRight();
                }
                bLangPackages = compiler.compilePackages(isBuild);
                LSCompilerCache.putPackages(key, bLangPackages, context);
            } else {
                bLangPackages = compiler.compilePackages(isBuild);
            }
            if (config.isTraceLogEnabled()) {
                long endTime = System.nanoTime();
                long eTime = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
                LSClientLogger.logTrace("Operation '" + context.getOperation().getName() + "' {projectRoot: '" + projectRoot + "'}, compilation took " + eTime + "ms");
            }
            return bLangPackages;
        }
        catch (RuntimeException e) {
            LSCompilerCache.markOutDated(key);
            throw new CompilationFailedException("Oh no, something really went wrong. Bad. Sad.", e);
        }
    }

    private static PackageID generatePackageFromManifest(String pkgName, String projectRoot) {
        Manifest manifest = LSCompilerUtil.getManifest(Paths.get(projectRoot, new String[0]));
        Name orgName = manifest.getProject().getOrgName() == null || manifest.getProject().getOrgName().isEmpty() ? Names.ANON_ORG : new Name(manifest.getProject().getOrgName());
        Name version = manifest.getProject().getVersion() == null || manifest.getProject().getVersion().isEmpty() ? Names.DEFAULT_VERSION : new Name(manifest.getProject().getVersion());
        return new PackageID(orgName, new Name(pkgName), version);
    }

    private static Optional<BLangPackage> filterCurrentPackage(List<BLangPackage> packages, LSContext context) {
        String currentPkg = (String)context.get(DocumentServiceKeys.CURRENT_PKG_NAME_KEY);
        return packages.stream().filter(bLangPackage -> bLangPackage.packageID.name.getValue().equals(currentPkg)).findAny();
    }
}

