/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSPackageCache;
import org.ballerinalang.langserver.compiler.common.modal.BallerinaPackage;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.PackageLoader;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.util.RepoUtils;

public class LSPackageLoader {
    private static final String LIB_REPO_DIR = "lib/repo";
    private static final String DOT = ".";
    private static final String BALLERINA_HOME = "ballerina.home";
    private static List<BallerinaPackage> sdkPackages = LSPackageLoader.getSDKPackagesFromSrcDir();
    private static List<BallerinaPackage> homeRepoPackages = LSPackageLoader.getPackagesFromHomeRepo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static BLangPackage getPackageById(CompilerContext context, PackageID packageID) {
        BLangPackage bLangPackage = LSPackageCache.getInstance(context).get(packageID);
        if (bLangPackage != null) return bLangPackage;
        Class<LSPackageLoader> clazz = LSPackageLoader.class;
        synchronized (LSPackageLoader.class) {
            bLangPackage = LSPackageCache.getInstance(context).get(packageID);
            if (bLangPackage != null) return bLangPackage;
            PackageLoader pkgLoader = PackageLoader.getInstance((CompilerContext)context);
            return pkgLoader.loadAndDefinePackage(packageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<BPackageSymbol> getPackageSymbolById(CompilerContext context, PackageID packageID) {
        Class<LSPackageLoader> clazz = LSPackageLoader.class;
        synchronized (LSPackageLoader.class) {
            PackageLoader pkgLoader = PackageLoader.getInstance((CompilerContext)context);
            BPackageSymbol packageSymbol = pkgLoader.loadPackageSymbol(packageID, null, null);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return Optional.ofNullable(packageSymbol);
        }
    }

    private static List<BallerinaPackage> getSDKPackagesFromSrcDir() {
        String ballerinaLibRepoDir;
        File reposDir;
        String[] repos;
        ArrayList<BallerinaPackage> ballerinaPackages = new ArrayList<BallerinaPackage>();
        String ballerinaSDKHome = System.getProperty(BALLERINA_HOME);
        if (ballerinaSDKHome != null && (repos = (reposDir = new File(ballerinaLibRepoDir = Paths.get(ballerinaSDKHome, LIB_REPO_DIR).toString())).list((dir, name) -> !name.startsWith(DOT))) != null) {
            for (String repo : repos) {
                String repoDir = Paths.get(ballerinaLibRepoDir, repo).toString();
                File packageDir = new File(repoDir);
                String[] packageNames = packageDir.list((dir, name) -> !name.startsWith(DOT));
                if (packageNames == null) continue;
                for (String name2 : packageNames) {
                    if (name2 == null || "ballerina".equals(repo) && name2.contains("__internal") || name2.contains(".balx")) continue;
                    BallerinaPackage ballerinaPackage = new BallerinaPackage(repo, name2, null);
                    ballerinaPackages.add(ballerinaPackage);
                }
            }
        }
        return ballerinaPackages;
    }

    private static List<BallerinaPackage> getPackagesFromHomeRepo() {
        File[] orgNames;
        ArrayList<BallerinaPackage> ballerinaPackages = new ArrayList<BallerinaPackage>();
        String homeRepoPath = Paths.get(RepoUtils.createAndGetHomeReposPath().toString(), "caches", "central.ballerina.io").toString();
        File homeRepo = new File(homeRepoPath);
        if (homeRepo.exists() && homeRepo.isDirectory() && (orgNames = homeRepo.listFiles((dir, name) -> !name.startsWith(DOT))) != null) {
            for (File orgDir : orgNames) {
                if (!orgDir.isDirectory()) continue;
                String orgName = orgDir.getName();
                File[] packageNames = orgDir.listFiles((dir, name) -> !name.startsWith(DOT));
                if (packageNames == null) continue;
                for (File pkgDir : packageNames) {
                    if (!pkgDir.isDirectory()) continue;
                    String pkgName = pkgDir.getName();
                    File[] versionNames = pkgDir.listFiles((dir, name) -> !name.startsWith(DOT));
                    if (versionNames == null) continue;
                    for (File versionDir : versionNames) {
                        if (!versionDir.isDirectory()) continue;
                        String version = versionDir.getName();
                        ballerinaPackages.add(new BallerinaPackage(orgName, pkgName, version));
                    }
                }
            }
        }
        return ballerinaPackages;
    }

    public static List<BallerinaPackage> getSdkPackages() {
        return new ArrayList<BallerinaPackage>(sdkPackages);
    }

    public static List<BallerinaPackage> getHomeRepoPackages() {
        return new ArrayList<BallerinaPackage>(homeRepoPackages);
    }

    public static void clearHomeRepoPackages() {
        homeRepoPackages.clear();
    }

    public static List<BallerinaPackage> getCurrentProjectModules(BLangPackage pkg, LSContext context) {
        ArrayList<BallerinaPackage> packageList = new ArrayList<BallerinaPackage>();
        LSDocumentIdentifier lsDocument = (LSDocumentIdentifier)context.get(DocumentServiceKeys.LS_DOCUMENT_KEY);
        if (lsDocument == null || !lsDocument.isWithinProject()) {
            return packageList;
        }
        String currentModuleName = (String)context.get(DocumentServiceKeys.CURRENT_PKG_NAME_KEY);
        for (String moduleName : lsDocument.getProjectModules()) {
            if (currentModuleName.equals(moduleName)) continue;
            packageList.add(new BallerinaPackage(pkg.packageID.orgName.value, moduleName, pkg.packageID.version.value));
        }
        return packageList;
    }
}

