/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.common;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;

public class LSDocumentIdentifierImpl
implements LSDocumentIdentifier {
    private Path path;
    private String uri;
    private String projectRoot;
    private List<String> projectModules = new ArrayList<String>();
    private boolean withinProject = false;
    private String ownerModule = "";
    private Path ownerModulePath = null;

    public LSDocumentIdentifierImpl(String uri) {
        try {
            this.uri = uri;
            this.path = Paths.get(new URL(uri).toURI());
            this.projectRoot = LSCompilerUtil.getProjectRoot(this.path);
            if (this.projectRoot == null) {
                return;
            }
            try {
                this.withinProject = !Files.isSameFile(this.path.getParent(), Paths.get(this.projectRoot, new String[0]));
            }
            catch (IOException e) {
                this.withinProject = false;
            }
            if (this.withinProject) {
                this.projectModules = this.getCurrentProjectModules(Paths.get(this.projectRoot, new String[0]));
                this.ownerModule = this.getModuleNameForDocument(this.projectRoot, this.path.toString());
                this.ownerModulePath = Paths.get(this.projectRoot, new String[0]).resolve("src").resolve(this.ownerModule);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LSDocumentIdentifierImpl(Path path, String projectRoot) {
        this.uri = path.toUri().toString();
        this.projectRoot = projectRoot;
        this.path = path;
        this.withinProject = true;
    }

    public Path getPath() {
        return this.path;
    }

    public Path getProjectRootPath() {
        return Paths.get(this.projectRoot, new String[0]);
    }

    public URI getURI() throws MalformedURLException, URISyntaxException {
        return new URL(this.uri).toURI();
    }

    public String getURIString() {
        return this.uri;
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setProjectRootRoot(String sourceRoot) {
        this.projectRoot = sourceRoot;
    }

    public List<String> getProjectModules() {
        return this.projectModules;
    }

    public boolean isWithinProject() {
        return this.withinProject;
    }

    public String getOwnerModule() {
        return this.ownerModule;
    }

    public Path getOwnerModulePath() {
        return this.ownerModulePath;
    }

    public String toString() {
        return "{projectRoot:" + this.projectRoot + ", uri:" + this.uri + "}";
    }

    private String getModuleNameForDocument(String projectRoot, String filePath) {
        String packageName = "";
        String packageStructure = filePath.substring(projectRoot.length() + 1);
        String[] splittedPackageStructure = packageStructure.split(Pattern.quote(File.separator));
        if (splittedPackageStructure.length > 0 && !splittedPackageStructure[0].endsWith(".bal")) {
            packageName = packageStructure.split(Pattern.quote(File.separator))[1];
        }
        return packageName;
    }

    private List<String> getCurrentProjectModules(Path projectRoot) {
        File[] files = projectRoot.resolve("src").toFile().listFiles();
        if (files == null) {
            return new ArrayList<String>();
        }
        List<File> fileList = Arrays.asList(files);
        return fileList.stream().filter(file -> file.isDirectory() && !file.isHidden()).map(File::getName).collect(Collectors.toList());
    }
}

