/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.config;

import org.ballerinalang.langserver.compiler.config.CodeLensConfig;
import org.ballerinalang.langserver.compiler.config.GoToDefinitionConfig;

public class LSClientConfig {
    private final String home;
    private final boolean allowExperimental;
    private final boolean debugLog;
    private final CodeLensConfig codeLens;
    private final boolean traceLog;
    private final GoToDefinitionConfig goToDefinition;

    private LSClientConfig() {
        this.home = "";
        String balDebugLog = System.getenv("BAL_DEBUG_LOG");
        String balTraceLog = System.getenv("BAL_TRACE_LOG");
        String balExperimental = System.getenv("BAL_EXPERIMENTAL");
        String balDefStdLibs = System.getenv("BAL_DEF_STD_LIBS");
        this.allowExperimental = Boolean.parseBoolean(balExperimental);
        this.debugLog = Boolean.parseBoolean(balDebugLog);
        this.traceLog = Boolean.parseBoolean(balTraceLog);
        this.codeLens = new CodeLensConfig();
        this.goToDefinition = balDefStdLibs != null ? new GoToDefinitionConfig(Boolean.parseBoolean(balDefStdLibs)) : new GoToDefinitionConfig(true);
    }

    public static LSClientConfig getDefault() {
        return new LSClientConfig();
    }

    public String getHome() {
        return this.home;
    }

    public boolean isAllowExperimental() {
        return this.allowExperimental;
    }

    public boolean isDebugLogEnabled() {
        return this.debugLog;
    }

    public CodeLensConfig getCodeLens() {
        return this.codeLens;
    }

    public boolean isTraceLogEnabled() {
        return this.traceLog;
    }

    public GoToDefinitionConfig getGoToDefinition() {
        return this.goToDefinition;
    }
}

