/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.workspace;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.compiler.workspace.WorkspaceDocument;
import org.ballerinalang.langserver.compiler.workspace.WorkspaceDocumentManagerImpl;
import org.eclipse.lsp4j.CodeLens;

public class ExtendedWorkspaceDocumentManagerImpl
extends WorkspaceDocumentManagerImpl {
    private volatile WorkspaceDocument tempDocument;
    private volatile boolean isExplicitMode;
    private static final ExtendedWorkspaceDocumentManagerImpl INSTANCE = new ExtendedWorkspaceDocumentManagerImpl();

    public static ExtendedWorkspaceDocumentManagerImpl getInstance() {
        return INSTANCE;
    }

    private ExtendedWorkspaceDocumentManagerImpl() {
    }

    @Override
    public boolean isFileOpen(Path filePath) {
        if (this.isExplicitMode && this.isTempFile(filePath)) {
            return true;
        }
        return super.isFileOpen(filePath);
    }

    @Override
    public void openFile(Path filePath, String content) throws WorkspaceDocumentException {
        this.openOrUpdateFile(filePath, content);
    }

    @Override
    public void updateFile(Path filePath, String updatedContent) throws WorkspaceDocumentException {
        this.openOrUpdateFile(filePath, updatedContent);
    }

    @Override
    public void setCodeLenses(Path filePath, List<CodeLens> codeLens) throws WorkspaceDocumentException {
        if (this.isExplicitMode && this.isTempFile(filePath)) {
            this.tempDocument.setCodeLenses(codeLens);
        } else if (super.isFileOpen(filePath)) {
            super.setCodeLenses(filePath, codeLens);
        } else {
            throw new WorkspaceDocumentException("File " + filePath.toString() + " is not opened in document manager.");
        }
    }

    private void openOrUpdateFile(Path filePath, String content) throws WorkspaceDocumentException {
        if (this.isExplicitMode && this.isTempFile(filePath)) {
            this.tempDocument.setContent(content);
        } else if (super.isFileOpen(filePath)) {
            super.updateFile(filePath, content);
        } else {
            super.openFile(filePath, content);
        }
    }

    @Override
    public void closeFile(Path filePath) throws WorkspaceDocumentException {
        if (!this.isExplicitMode && !this.isTempFile(filePath)) {
            super.closeFile(filePath);
        }
    }

    @Override
    public List<CodeLens> getCodeLenses(Path filePath) {
        if (this.isExplicitMode && this.isTempFile(filePath)) {
            return this.tempDocument.getCodeLenses();
        }
        return super.getCodeLenses(filePath);
    }

    @Override
    public String getFileContent(Path filePath) throws WorkspaceDocumentException {
        if (this.isExplicitMode && this.isTempFile(filePath)) {
            return this.tempDocument.getContent();
        }
        return super.getFileContent(filePath);
    }

    private boolean isTempFile(Path filePath) {
        try {
            return this.tempDocument != null && Files.isSameFile(this.tempDocument.getPath(), filePath);
        }
        catch (IOException e) {
            return false;
        }
    }

    public Optional<Lock> enableExplicitMode(Path tempFile) {
        Optional<Lock> lock = super.lockFile(tempFile);
        if (this.tempDocument == null) {
            this.tempDocument = new WorkspaceDocument(tempFile, "", true);
        } else {
            this.tempDocument.setPath(tempFile);
        }
        this.isExplicitMode = true;
        return lock;
    }

    public void disableExplicitMode(Lock lock) {
        this.isExplicitMode = false;
        Optional.ofNullable(lock).ifPresent(Lock::unlock);
    }
}

