/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.workspace;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.compiler.common.LSDocumentIdentifierImpl;
import org.eclipse.lsp4j.CodeLens;

public class WorkspaceDocument {
    private List<CodeLens> codeLenses;
    private Path path;
    private String content;
    private String prunedContent;
    private boolean usePrunedSource;
    private LSDocumentIdentifier lsDocument;

    public WorkspaceDocument(Path path, String content, boolean isTempFile) {
        this.path = path;
        this.content = content;
        this.codeLenses = new ArrayList<CodeLens>();
        this.usePrunedSource = false;
        this.lsDocument = isTempFile ? null : new LSDocumentIdentifierImpl(path.toUri().toString());
    }

    public WorkspaceDocument(Path path, String content) {
        this(path, content, false);
    }

    public List<CodeLens> getCodeLenses() {
        return this.codeLenses;
    }

    public void setCodeLenses(List<CodeLens> codeLenses) {
        this.codeLenses = codeLenses;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public String getContent() {
        if (this.usePrunedSource) {
            return this.prunedContent;
        }
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setPrunedContent(String prunedContent) {
        this.prunedContent = prunedContent;
        this.usePrunedSource = true;
    }

    public void resetPrunedContent() {
        this.prunedContent = null;
        this.usePrunedSource = false;
    }

    public LSDocumentIdentifier getLSDocument() {
        return this.lsDocument;
    }

    public String toString() {
        String cont = this.usePrunedSource ? this.prunedContent : this.content;
        return "{path:" + this.path + ", content:" + cont + "}";
    }
}

