/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.workspace;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;
import org.ballerinalang.langserver.compiler.common.LSDocumentIdentifierImpl;
import org.ballerinalang.langserver.compiler.workspace.WorkspaceDocument;
import org.ballerinalang.langserver.compiler.workspace.repository.LangServerFSProjectDirectory;
import org.eclipse.lsp4j.CodeLens;

public class WorkspaceDocumentManagerImpl
implements WorkspaceDocumentManager {
    private volatile Map<Path, DocumentPair> documentList = new ConcurrentHashMap<Path, DocumentPair>();
    private static final WorkspaceDocumentManagerImpl INSTANCE = new WorkspaceDocumentManagerImpl();

    protected WorkspaceDocumentManagerImpl() {
    }

    public static WorkspaceDocumentManagerImpl getInstance() {
        return INSTANCE;
    }

    public boolean isFileOpen(Path filePath) {
        return filePath != null && this.documentList.containsKey(filePath) && this.documentList.get(filePath).getDocument().isPresent();
    }

    public void openFile(Path filePath, String content) throws WorkspaceDocumentException {
        if (this.isFileOpen(filePath)) {
            throw new WorkspaceDocumentException("File " + filePath.toString() + " is already opened in document manager.");
        }
        this.documentList.put(filePath, new DocumentPair(new WorkspaceDocument(filePath, content)));
        LSDocumentIdentifierImpl document = new LSDocumentIdentifierImpl(filePath.toUri().toString());
        if (document.isWithinProject()) {
            this.rescanProjectRoot(filePath);
        }
    }

    public void updateFile(Path filePath, String updatedContent) throws WorkspaceDocumentException {
        if (!this.isFileOpen(filePath)) {
            throw new WorkspaceDocumentException("File " + filePath.toString() + " is not opened in document manager.");
        }
        this.documentList.get(filePath).getDocument().ifPresent(document -> document.setContent(updatedContent));
    }

    public void setCodeLenses(Path filePath, List<CodeLens> codeLens) throws WorkspaceDocumentException {
        if (!this.isFileOpen(filePath)) {
            throw new WorkspaceDocumentException("File " + filePath.toString() + " is not opened in document manager.");
        }
        this.documentList.get(filePath).getDocument().ifPresent(document -> document.setCodeLenses(codeLens));
    }

    public void setPrunedContent(Path filePath, String prunedSource) throws WorkspaceDocumentException {
        if (!this.isFileOpen(filePath)) {
            throw new WorkspaceDocumentException("File " + filePath.toString() + " is not opened in document manager.");
        }
        this.documentList.get(filePath).getDocument().ifPresent(document -> document.setPrunedContent(prunedSource));
    }

    public void resetPrunedContent(Path filePath) throws WorkspaceDocumentException {
        if (!this.isFileOpen(filePath)) {
            throw new WorkspaceDocumentException("File " + filePath.toString() + " is not opened in document manager.");
        }
        this.documentList.get(filePath).getDocument().ifPresent(WorkspaceDocument::resetPrunedContent);
    }

    public void closeFile(Path filePath) throws WorkspaceDocumentException {
        if (this.isFileOpen(filePath)) {
            Lock lock = this.documentList.get(filePath).getLock();
            try {
                lock.lock();
                this.documentList.get(filePath).setDocument(null);
                this.documentList.remove(filePath);
            }
            finally {
                lock.unlock();
            }
            LSDocumentIdentifierImpl document = new LSDocumentIdentifierImpl(filePath.toUri().toString());
            if (document.isWithinProject()) {
                this.rescanProjectRoot(filePath);
            }
        } else {
            throw new WorkspaceDocumentException("File " + filePath.toString() + " is not opened in document manager.");
        }
    }

    public List<CodeLens> getCodeLenses(Path filePath) {
        if (this.isFileOpen(filePath) && this.documentList.get(filePath) != null) {
            return this.documentList.get(filePath).getDocument().map(WorkspaceDocument::getCodeLenses).orElse(null);
        }
        return new ArrayList<CodeLens>();
    }

    public LSDocumentIdentifier getLSDocument(Path filePath) throws WorkspaceDocumentException {
        DocumentPair documentPair = this.documentList.get(filePath);
        if (this.isFileOpen(filePath) && documentPair != null && documentPair.getDocument().isPresent()) {
            return documentPair.getDocument().get().getLSDocument();
        }
        throw new WorkspaceDocumentException("Cannot find LSDocument for the give file path: [" + filePath.toString() + "]");
    }

    public String getFileContent(Path filePath) throws WorkspaceDocumentException {
        if (this.isFileOpen(filePath) && this.documentList.get(filePath) != null) {
            return this.documentList.get(filePath).getDocument().map(WorkspaceDocument::getContent).orElse(null);
        }
        return this.readFromFileSystem(filePath);
    }

    public Optional<Lock> lockFile(Path filePath) {
        Optional<Lock> lock = Optional.ofNullable(filePath).map(path -> Optional.ofNullable(this.documentList.get(path)).map(DocumentPair::getLock).orElseGet(() -> {
            WorkspaceDocumentManagerImpl workspaceDocumentManagerImpl = this;
            synchronized (workspaceDocumentManagerImpl) {
                return Optional.ofNullable(this.documentList.get(path)).map(DocumentPair::getLock).orElseGet(() -> {
                    DocumentPair docPair = new DocumentPair(null);
                    this.documentList.put(filePath, docPair);
                    return docPair.getLock();
                });
            }
        }));
        lock.ifPresent(Lock::lock);
        return lock;
    }

    public Set<Path> getAllFilePaths() {
        return this.documentList.entrySet().stream().filter(entry -> ((DocumentPair)entry.getValue()).getDocument().isPresent()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).keySet();
    }

    public void clearAllFilePaths() {
        this.documentList.clear();
    }

    private String readFromFileSystem(Path filePath) throws WorkspaceDocumentException {
        try {
            if (Files.exists(filePath, new LinkOption[0])) {
                byte[] encoded = Files.readAllBytes(filePath);
                return new String(encoded, Charset.defaultCharset());
            }
            throw new WorkspaceDocumentException("Error in reading non-existent file '" + filePath);
        }
        catch (IOException e) {
            throw new WorkspaceDocumentException("Error in reading file '" + filePath + "': " + e.getMessage(), (Throwable)e);
        }
    }

    private void rescanProjectRoot(Path filePath) {
        Path projectRoot = Paths.get(LSCompilerUtil.getProjectRoot(filePath), new String[0]);
        LangServerFSProjectDirectory projectDirectory = LangServerFSProjectDirectory.getInstance(projectRoot, this);
        projectDirectory.rescanProjectRoot();
    }

    public static class DocumentPair {
        private final Lock lock;
        private WorkspaceDocument document;

        public DocumentPair(WorkspaceDocument document) {
            this.document = document;
            this.lock = new ReentrantLock(true);
        }

        public Lock getLock() {
            return this.lock;
        }

        public Optional<WorkspaceDocument> getDocument() {
            return Optional.ofNullable(this.document);
        }

        public void setDocument(WorkspaceDocument document) {
            this.document = document;
        }
    }
}

