/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.workspace.repository;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompilerInput;
import org.ballerinalang.repository.PackageEntity;
import org.ballerinalang.repository.PackageRepository;
import org.ballerinalang.repository.PackageSource;
import org.ballerinalang.repository.fs.GeneralFSPackageRepository;
import org.wso2.ballerinalang.compiler.packaging.RepoHierarchy;

public class WorkspacePackageRepository
extends GeneralFSPackageRepository {
    private static final String BAL_SOURCE_EXT = ".bal";
    private WorkspaceDocumentManager documentManager;

    public WorkspacePackageRepository(String programDirRoot, WorkspaceDocumentManager documentManager) {
        super(Paths.get(programDirRoot, new String[0]));
        this.documentManager = documentManager;
    }

    protected PackageSource lookupPackageSource(PackageID pkgID) {
        Path path = this.generatePath(pkgID);
        return new WorkspacePackageSource(pkgID, path);
    }

    protected PackageSource lookupPackageSource(PackageID pkgID, String entryName) {
        Path path = this.generatePath(pkgID);
        try {
            return new WorkspacePackageSource(pkgID, path, entryName);
        }
        catch (GeneralFSPackageRepository.FSPackageEntityNotAvailableException e) {
            return null;
        }
    }

    private Path getResolvedPathFromPackagePath(Path pkgPath) {
        Path resolvedPath = pkgPath;
        if (Files.exists(pkgPath, new LinkOption[0])) {
            try {
                resolvedPath = resolvedPath.toRealPath(new LinkOption[0]);
            }
            catch (IOException iOException) {}
        } else if (pkgPath.getName(pkgPath.getNameCount() - 1).toString().equals(PackageID.DEFAULT.getName().toString())) {
            resolvedPath = pkgPath.getRoot().resolve(pkgPath.subpath(0, pkgPath.getNameCount() - 1));
        }
        return resolvedPath;
    }

    public class WorkspacePackageSource
    implements PackageSource {
        PackageID pkgID;
        Path pkgPath;
        private List<String> cachedEntryNames;

        WorkspacePackageSource(PackageID pkgID, Path pkgPath) {
            this.pkgID = pkgID;
            this.pkgPath = pkgPath;
        }

        WorkspacePackageSource(PackageID pkgID, Path pkgPath, String entryName) throws GeneralFSPackageRepository.FSPackageEntityNotAvailableException {
            this.pkgID = pkgID;
            this.pkgPath = pkgPath;
            Path resolvedPath = WorkspacePackageRepository.this.getResolvedPathFromPackagePath(pkgPath).resolve(entryName);
            if (!Files.exists(resolvedPath, new LinkOption[0]) && !WorkspacePackageRepository.this.documentManager.isFileOpen(resolvedPath)) {
                throw new GeneralFSPackageRepository.FSPackageEntityNotAvailableException((GeneralFSPackageRepository)WorkspacePackageRepository.this);
            }
            this.cachedEntryNames = Arrays.asList(entryName);
        }

        public PackageID getPackageId() {
            return this.pkgID;
        }

        public List<String> getEntryNames() {
            if (this.cachedEntryNames == null && Files.exists(this.pkgPath, new LinkOption[0])) {
                try {
                    List files = Files.walk(this.pkgPath, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(e -> e.getFileName().toString().endsWith(WorkspacePackageRepository.BAL_SOURCE_EXT)).collect(Collectors.toList());
                    this.cachedEntryNames = new ArrayList<String>(files.size());
                    files.stream().forEach(e -> this.cachedEntryNames.add(e.getFileName().toString()));
                }
                catch (IOException e2) {
                    throw new RuntimeException("Error in listing packages at '" + this.pkgID + "': " + e2.getMessage(), e2);
                }
            }
            return this.cachedEntryNames;
        }

        public RepoHierarchy getRepoHierarchy() {
            return null;
        }

        public CompilerInput getPackageSourceEntry(String name) {
            return new WorkspaceCompilerInput(name);
        }

        public List<CompilerInput> getPackageSourceEntries() {
            if (this.getEntryNames() == null) {
                return new ArrayList<CompilerInput>();
            }
            return this.getEntryNames().stream().map(this::getPackageSourceEntry).collect(Collectors.toList());
        }

        public PackageRepository getPackageRepository() {
            return WorkspacePackageRepository.this;
        }

        public PackageEntity.Kind getKind() {
            return PackageEntity.Kind.SOURCE;
        }

        public String getName() {
            return this.getPackageId().toString();
        }

        public class WorkspaceCompilerInput
        implements CompilerInput {
            private String name;
            private byte[] code;

            private WorkspaceCompilerInput(String name) {
                this.name = name;
                Path filePath = WorkspacePackageRepository.this.getResolvedPathFromPackagePath(WorkspacePackageRepository.this.basePath.resolve(WorkspacePackageSource.this.pkgPath)).resolve(name);
                if (WorkspacePackageRepository.this.documentManager.isFileOpen(filePath)) {
                    try {
                        this.code = WorkspacePackageRepository.this.documentManager.getFileContent(filePath).getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException | WorkspaceDocumentException e) {
                        throw new RuntimeException("Error in loading package source entry '" + filePath + "': " + e.getMessage(), e);
                    }
                }
                try {
                    this.code = Files.readAllBytes(filePath);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error in loading package source entry '" + filePath + "': " + e.getMessage(), e);
                }
            }

            public String getEntryName() {
                return this.name;
            }

            public byte[] getCode() {
                return (byte[])this.code.clone();
            }
        }
    }
}

