/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinax.azurefunctions.AzureFunctionsException;
import org.ballerinax.azurefunctions.FunctionDeploymentContext;
import org.ballerinax.azurefunctions.FunctionsArtifact;
import org.ballerinax.azurefunctions.GlobalContext;
import org.ballerinax.azurefunctions.HandlerFactory;
import org.ballerinax.azurefunctions.ParameterHandler;
import org.ballerinax.azurefunctions.ReturnHandler;
import org.ballerinax.azurefunctions.Utils;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

@SupportedAnnotationPackages(value={"ballerinax/azure.functions:0.0.0"})
public class AzureFunctionsPlugin
extends AbstractCompilerPlugin {
    private static final PrintStream OUT = System.out;
    private static Map<String, FunctionDeploymentContext> generatedFunctions = new LinkedHashMap<String, FunctionDeploymentContext>();
    private DiagnosticLog dlog;
    private GlobalContext globalCtx;

    public void init(DiagnosticLog dlog) {
        this.dlog = dlog;
    }

    public void setCompilerContext(CompilerContext cctx) {
        this.globalCtx = new GlobalContext(cctx);
    }

    public void process(PackageNode packageNode) {
        BLangPackage bpn = (BLangPackage)packageNode;
        this.globalCtx.pos = bpn.pos;
        this.globalCtx.azureFuncsPkgSymbol = Utils.extractAzureFuncsPackageSymbol(bpn);
        try {
            generatedFunctions.putAll(this.generateHandlerFunctions(bpn));
            this.registerHandlerFunctions(bpn, generatedFunctions);
        }
        catch (AzureFunctionsException e) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, packageNode.getPosition(), (CharSequence)e.getMessage());
        }
    }

    private FunctionDeploymentContext createFuncDeplContext(BLangPackage packageNode, BLangFunction sourceFunc) throws AzureFunctionsException {
        BLangFunction func;
        FunctionDeploymentContext ctx = new FunctionDeploymentContext();
        ctx.sourceFunction = sourceFunc;
        ctx.globalCtx = this.globalCtx;
        ctx.function = func = Utils.createHandlerFunction(this.globalCtx, sourceFunc.pos, sourceFunc.name.value, packageNode);
        ctx.handlerParams = ((BLangSimpleVariable)func.getParameters().get((int)0)).symbol;
        for (BLangSimpleVariable param : sourceFunc.getParameters()) {
            ctx.parameterHandlers.add(HandlerFactory.createParameterHandler(ctx, param));
        }
        ctx.returnHandler = HandlerFactory.createReturnHandler(ctx, Utils.extractNonErrorType(ctx.globalCtx, sourceFunc.getReturnTypeNode().type), sourceFunc.getReturnTypeAnnotationAttachments());
        for (ParameterHandler ph : ctx.parameterHandlers) {
            ph.init(ctx);
        }
        if (ctx.returnHandler != null) {
            ctx.returnHandler.init(ctx);
        }
        return ctx;
    }

    private FunctionDeploymentContext generateHandlerFunction(BLangPackage packageNode, BLangFunction sourceFunc) throws AzureFunctionsException {
        FunctionDeploymentContext ctx = this.createFuncDeplContext(packageNode, sourceFunc);
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        for (ParameterHandler parameterHandler : ctx.parameterHandlers) {
            args.add(Utils.createCheckedExpr(ctx.globalCtx, parameterHandler.invocationProcess()));
        }
        BLangSimpleVariable retVal = Utils.addFunctionCall(ctx, (BSymbol)sourceFunc.symbol, true, args.toArray(new BLangExpression[0]));
        for (ParameterHandler ph : ctx.parameterHandlers) {
            ph.postInvocationProcess();
        }
        ReturnHandler returnHandler = ctx.returnHandler;
        if (returnHandler != null) {
            returnHandler.postInvocationProcess((BLangExpression)Utils.createVariableRef(ctx.globalCtx, retVal.symbol));
        }
        return ctx;
    }

    private Map<String, FunctionDeploymentContext> generateHandlerFunctions(BLangPackage packageNode) throws AzureFunctionsException {
        LinkedHashMap<String, FunctionDeploymentContext> funcCtxs = new LinkedHashMap<String, FunctionDeploymentContext>();
        for (FunctionNode fn : packageNode.getFunctions()) {
            BLangFunction bfn = (BLangFunction)fn;
            if (!Utils.isAzureFunction(bfn, this.dlog)) continue;
            funcCtxs.put(bfn.name.value, this.generateHandlerFunction(packageNode, bfn));
        }
        for (FunctionDeploymentContext ctx : funcCtxs.values()) {
            packageNode.addFunction((FunctionNode)ctx.function);
        }
        return funcCtxs;
    }

    private void registerHandlerFunctions(BLangPackage myPkg, Map<String, FunctionDeploymentContext> azureFunctions) {
        if (azureFunctions.isEmpty()) {
            return;
        }
        Utils.addDummyService(this.globalCtx, myPkg);
        BPackageSymbol azureFuncsPkgSymbol = this.globalCtx.azureFuncsPkgSymbol;
        if (azureFuncsPkgSymbol == null) {
            throw new BallerinaException("Azure Functions package symbol cannot be found");
        }
        BLangFunction epFunc = Utils.extractMainFunction(myPkg);
        if (epFunc == null) {
            epFunc = Utils.createFunction(this.globalCtx, "main", myPkg);
            myPkg.addFunction((FunctionNode)epFunc);
        } else {
            ((BLangBlockFunctionBody)epFunc.body).stmts.clear();
        }
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)epFunc.body;
        for (Map.Entry<String, FunctionDeploymentContext> entry : azureFunctions.entrySet()) {
            String name = entry.getKey();
            BLangFunction func = entry.getValue().function;
            Utils.addRegisterCall(this.globalCtx, myPkg.pos, azureFuncsPkgSymbol, body, name, func);
        }
    }

    public void codeGenerated(PackageID packageID, Path binaryPath) {
        if (generatedFunctions.isEmpty()) {
            return;
        }
        OUT.println("\t@azure.functions:Function: " + String.join((CharSequence)", ", generatedFunctions.keySet()));
        try {
            this.generateFunctionsArtifact(generatedFunctions, binaryPath, "azure-functions.zip");
        }
        catch (IOException | AzureFunctionsException e) {
            String msg = "Error generating Azure Functions: " + e.getMessage();
            OUT.println(msg);
            throw new BallerinaException(msg, (Throwable)e);
        }
        OUT.println("\n\tRun the following command to deploy Ballerina Azure Functions:");
        OUT.println("\taz functionapp deployment source config-zip -g <resource_group> -n <function_app_name> --src azure-functions.zip");
    }

    private void generateFunctionsArtifact(Map<String, FunctionDeploymentContext> functions, Path binaryPath, String outputFileName) throws AzureFunctionsException, IOException {
        new FunctionsArtifact(functions, binaryPath).generate(outputFileName);
    }
}

