/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions.handlers;

import java.util.Map;
import org.ballerinax.azurefunctions.AzureFunctionsException;
import org.ballerinax.azurefunctions.BindingType;
import org.ballerinax.azurefunctions.FunctionDeploymentContext;
import org.ballerinax.azurefunctions.ParameterHandler;
import org.ballerinax.azurefunctions.Utils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;

public abstract class AbstractParameterHandler
implements ParameterHandler {
    protected FunctionDeploymentContext ctx;
    protected BLangSimpleVariable param;
    protected BLangAnnotationAttachment annotation;
    protected String name;
    protected BindingType bindingType;

    public AbstractParameterHandler(BLangSimpleVariable param, BLangAnnotationAttachment annotation, BindingType bindingType) {
        this.param = param;
        this.annotation = annotation;
        this.name = this.param.name.value;
        this.bindingType = bindingType;
    }

    @Override
    public void init(FunctionDeploymentContext ctx) {
        this.ctx = ctx;
        this.processBinding();
    }

    private String extractBindingDirection() {
        if (BindingType.INPUT.equals((Object)this.bindingType) || BindingType.TRIGGER.equals((Object)this.bindingType)) {
            return "in";
        }
        return "out";
    }

    private void processBinding() {
        Map<String, Object> binding = this.generateBinding();
        if (binding == null) {
            return;
        }
        binding.put("direction", this.extractBindingDirection());
        binding.put("name", this.name);
        Utils.addFunctionBinding(this.ctx, binding);
    }

    @Override
    public BindingType getBindingType() {
        return this.bindingType;
    }

    public AzureFunctionsException createError(String msg) {
        return new AzureFunctionsException("Error at function: '" + this.ctx.sourceFunction.name.value + "' parameter: '" + this.param.name.value + "' - " + msg);
    }

    public abstract Map<String, Object> generateBinding();
}

