/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions.handlers;

import java.util.Map;
import org.ballerinax.azurefunctions.AzureFunctionsException;
import org.ballerinax.azurefunctions.FunctionDeploymentContext;
import org.ballerinax.azurefunctions.ReturnHandler;
import org.ballerinax.azurefunctions.Utils;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;

public abstract class AbstractReturnHandler
implements ReturnHandler {
    protected FunctionDeploymentContext ctx;
    protected BType retType;
    protected BLangAnnotationAttachment annotation;

    public AbstractReturnHandler(BType retType, BLangAnnotationAttachment annotation) {
        this.retType = retType;
        this.annotation = annotation;
    }

    @Override
    public void init(FunctionDeploymentContext ctx) {
        this.ctx = ctx;
        this.processBinding();
    }

    private void processBinding() {
        Map<String, Object> binding = this.generateBinding();
        if (binding == null) {
            return;
        }
        binding.put("direction", "out");
        binding.put("name", "$return");
        Utils.addFunctionBinding(this.ctx, binding);
    }

    public AzureFunctionsException createError(String msg) {
        return new AzureFunctionsException("Error at function: '" + this.ctx.sourceFunction.name.value + " return - " + msg);
    }

    public abstract Map<String, Object> generateBinding();

    public BLangAnnotationAttachment getAnnotation() {
        return this.annotation;
    }
}

