/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions.handlers.cosmosdb;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinax.azurefunctions.AzureFunctionsException;
import org.ballerinax.azurefunctions.BindingType;
import org.ballerinax.azurefunctions.Utils;
import org.ballerinax.azurefunctions.handlers.AbstractParameterHandler;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class CosmosDBInputParameterHandler
extends AbstractParameterHandler {
    public CosmosDBInputParameterHandler(BLangSimpleVariable param, BLangAnnotationAttachment annotation) {
        super(param, annotation, BindingType.INPUT);
    }

    private boolean isSingleRecordQuery() {
        Map<String, Object> annonMap = Utils.extractAnnotationKeyValues(this.annotation);
        return annonMap.get("id") != null;
    }

    @Override
    public BLangExpression invocationProcess() throws AzureFunctionsException {
        boolean singleRecordQuery = this.isSingleRecordQuery();
        if (singleRecordQuery) {
            if (Utils.isJsonType(this.ctx.globalCtx, this.param.type)) {
                return Utils.createAzurePkgInvocationNode(this.ctx, "getJsonFromInputDataDoubleEscaped", new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), Utils.createStringLiteral(this.ctx.globalCtx, this.name)});
            }
            if (Utils.isOptionalRecordType(this.ctx.globalCtx, this.param.type)) {
                return Utils.createAzurePkgInvocationNode(this.ctx, "getOptionalBallerinaValueFromInputDataDoubleEscape", new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), Utils.createStringLiteral(this.ctx.globalCtx, this.name), Utils.createTypeDescExpr(this.ctx.globalCtx, this.param.type)});
            }
            throw this.createError("Type must be 'json' or an optional record type");
        }
        if (Utils.isJsonType(this.ctx.globalCtx, this.param.type)) {
            return Utils.createAzurePkgInvocationNode(this.ctx, "getJsonFromInput", new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), Utils.createStringLiteral(this.ctx.globalCtx, this.name)});
        }
        if (Utils.isRecordArrayType(this.ctx.globalCtx, this.param.type)) {
            return Utils.createAzurePkgInvocationNode(this.ctx, "getBallerinaValueFromInputData", new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), Utils.createStringLiteral(this.ctx.globalCtx, this.name), Utils.createTypeDescExpr(this.ctx.globalCtx, this.param.type)});
        }
        throw this.createError("Type must be 'json' or an array record type");
    }

    @Override
    public void postInvocationProcess() throws AzureFunctionsException {
    }

    @Override
    public Map<String, Object> generateBinding() {
        LinkedHashMap<String, Object> binding = new LinkedHashMap<String, Object>();
        Map<String, Object> annonMap = Utils.extractAnnotationKeyValues(this.annotation);
        binding.put("type", "cosmosDB");
        binding.put("connectionStringSetting", annonMap.get("connectionStringSetting"));
        binding.put("databaseName", annonMap.get("databaseName"));
        binding.put("collectionName", annonMap.get("collectionName"));
        binding.put("id", annonMap.get("id"));
        binding.put("sqlQuery", annonMap.get("sqlQuery"));
        binding.put("partitionKey", annonMap.get("partitionKey"));
        binding.put("preferredLocations", annonMap.get("preferredLocations"));
        return binding;
    }
}

