/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions.handlers.cosmosdb;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinax.azurefunctions.AzureFunctionsException;
import org.ballerinax.azurefunctions.Utils;
import org.ballerinax.azurefunctions.handlers.AbstractReturnHandler;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class CosmosDBReturnHandler
extends AbstractReturnHandler {
    public CosmosDBReturnHandler(BType retType, BLangAnnotationAttachment annotation) {
        super(retType, annotation);
    }

    @Override
    public void postInvocationProcess(BLangExpression returnValueExpr) throws AzureFunctionsException {
        if (Utils.isJsonType(this.ctx.globalCtx, this.retType)) {
            Utils.addAzurePkgFunctionCall(this.ctx, "setJsonReturn", true, new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), returnValueExpr});
        } else if (Utils.isRecordType(this.ctx.globalCtx, this.retType)) {
            Utils.addAzurePkgFunctionCall(this.ctx, "setBallerinaValueAsJsonReturn", true, new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), returnValueExpr});
        } else if (Utils.isRecordArrayType(this.ctx.globalCtx, this.retType)) {
            Utils.addAzurePkgFunctionCall(this.ctx, "setBallerinaValueAsJsonReturn", true, new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), returnValueExpr});
        } else {
            throw this.createError("Type '" + this.retType.tsymbol.name.value + "' is not supported");
        }
    }

    @Override
    public Map<String, Object> generateBinding() {
        LinkedHashMap<String, Object> binding = new LinkedHashMap<String, Object>();
        Map<String, Object> annonMap = Utils.extractAnnotationKeyValues(this.annotation);
        binding.put("type", "cosmosDB");
        binding.put("connectionStringSetting", annonMap.get("connectionStringSetting"));
        binding.put("databaseName", annonMap.get("databaseName"));
        binding.put("collectionName", annonMap.get("collectionName"));
        binding.put("createIfNotExists", annonMap.get("createIfNotExists"));
        binding.put("partitionKey", annonMap.get("partitionKey"));
        binding.put("collectionThroughput", annonMap.get("collectionThroughput"));
        binding.put("preferredLocations", annonMap.get("preferredLocations"));
        binding.put("useMultipleWriteLocations", annonMap.get("useMultipleWriteLocations"));
        return binding;
    }
}

