/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.xmlutils;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.TableValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.stdlib.xmlutils.JSONToXMLConverter;

public class ConvertUtils {
    private static final String OPTIONS_ATTRIBUTE_PREFIX = "attributePrefix";
    private static final String OPTIONS_ARRAY_ENTRY_TAG = "arrayEntryTag";

    private ConvertUtils() {
    }

    public static Object fromJSON(Object json, MapValue<?, ?> options) {
        try {
            String attributePrefix = (String)options.get((Object)OPTIONS_ATTRIBUTE_PREFIX);
            String arrayEntryTag = (String)options.get((Object)OPTIONS_ARRAY_ENTRY_TAG);
            return JSONToXMLConverter.convertToXML(json, attributePrefix, arrayEntryTag);
        }
        catch (Exception e) {
            return BallerinaErrors.createError((String)"{ballerina/xmlutils}Error", (String)e.getMessage());
        }
    }

    public static XMLValue fromTable(TableValue tableValue) {
        return XMLFactory.tableToXML((TableValue)tableValue);
    }
}

