/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.task.objects;

import java.util.Date;
import org.ballerinalang.stdlib.task.exceptions.SchedulingException;
import org.ballerinalang.stdlib.task.objects.AbstractTask;
import org.ballerinalang.stdlib.task.objects.TaskManager;
import org.ballerinalang.stdlib.task.utils.TaskJob;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class Timer
extends AbstractTask {
    private long interval;
    private long delay;

    public Timer(long delay, long interval) throws SchedulingException {
        this.validateTimerConfigurations(delay, interval);
        this.interval = interval;
        this.delay = delay;
    }

    public Timer(long delay, long interval, long maxRuns) throws SchedulingException {
        super(maxRuns);
        this.validateTimerConfigurations(delay, interval);
        this.interval = interval;
        this.delay = delay;
    }

    @Override
    public void start() throws SchedulingException {
        JobDataMap jobDataMap = this.getJobDataMapFromTask();
        try {
            this.scheduleTimer(jobDataMap);
        }
        catch (SchedulerException e) {
            throw new SchedulingException("Failed to schedule task.", e);
        }
    }

    public long getInterval() {
        return this.interval;
    }

    public long getDelay() {
        return this.delay;
    }

    private long getMaxRuns() {
        return this.maxRuns;
    }

    private void validateTimerConfigurations(long delay, long interval) throws SchedulingException {
        if (delay < 0L) {
            throw new SchedulingException("Timer scheduling delay should be a non-negative value.");
        }
        if (interval < 1L) {
            throw new SchedulingException("Timer scheduling interval should be a positive integer.");
        }
    }

    private void scheduleTimer(JobDataMap jobData) throws SchedulerException, SchedulingException {
        Trigger trigger;
        SimpleScheduleBuilder schedule = Timer.createSchedulerBuilder(this.getInterval(), this.getMaxRuns());
        String triggerId = this.getId();
        JobDetail job = JobBuilder.newJob(TaskJob.class).usingJobData(jobData).withIdentity(triggerId).build();
        if (this.getDelay() > 0L) {
            Date startTime = new Date(System.currentTimeMillis() + this.getDelay());
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerId).startAt(startTime).forJob(job).withSchedule((ScheduleBuilder)schedule).build();
        } else {
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerId).startNow().forJob(job).withSchedule((ScheduleBuilder)schedule).build();
        }
        TaskManager.getInstance().getScheduler().scheduleJob(job, trigger);
        this.quartzJobs.put(triggerId, job.getKey());
    }

    private static SimpleScheduleBuilder createSchedulerBuilder(long interval, long maxRuns) {
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionNextWithRemainingCount().withIntervalInMilliseconds(interval);
        if (maxRuns > 0L) {
            simpleScheduleBuilder.withRepeatCount((int)(maxRuns - 1L));
        } else {
            simpleScheduleBuilder.repeatForever();
        }
        return simpleScheduleBuilder;
    }
}

