/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.websocket;

import io.netty.channel.EventLoopGroup;
import java.util.Objects;
import org.wso2.transport.http.netty.contract.websocket.ClientHandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketClientConnector;
import org.wso2.transport.http.netty.contract.websocket.WebSocketClientConnectorConfig;
import org.wso2.transport.http.netty.contractimpl.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.contractimpl.sender.websocket.WebSocketClient;

public class DefaultWebSocketClientConnector
implements WebSocketClientConnector {
    private final WebSocketClient webSocketClient;
    private final WebSocketClientConnectorConfig clientConnectorConfig;

    public DefaultWebSocketClientConnector(WebSocketClientConnectorConfig clientConnectorConfig, EventLoopGroup wsClientEventLoopGroup) {
        this.webSocketClient = new WebSocketClient(wsClientEventLoopGroup, clientConnectorConfig);
        this.clientConnectorConfig = clientConnectorConfig;
    }

    @Override
    public ClientHandshakeFuture connect() {
        return this.webSocketClient.handshake();
    }

    @Override
    public void initializeSSLContext() throws Exception {
        SSLConfig sslConfig = this.clientConnectorConfig.getClientSSLConfig();
        if (Objects.nonNull(sslConfig)) {
            sslConfig.initializeSSLContext(false);
        }
    }
}

