/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.utils;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.ballerinalang.bindgen.command.BindingsGenerator;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.maven.Dependency;
import org.ballerinalang.maven.MavenResolver;
import org.ballerinalang.maven.exceptions.MavenResolverException;
import org.ballerinalang.toml.model.Library;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.model.Platform;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.TomlParserUtils;

public class BindgenMvnResolver {
    private PrintStream outStream;

    public BindgenMvnResolver(PrintStream outStream) {
        this.outStream = outStream;
    }

    public void mavenResolver(String groupId, String artifactId, String version, Path projectRoot, boolean resolve) throws BindgenException {
        Path mvnRepository = projectRoot == null ? (BindingsGenerator.getOutputPath() != null ? Paths.get(BindingsGenerator.getOutputPath(), "target", "platform-libs") : Paths.get(System.getProperty("user.dir"), "target", "platform-libs")) : Paths.get(projectRoot.toString(), "target", "platform-libs");
        BindgenMvnResolver.handleDependency(groupId, artifactId, version, mvnRepository.toString(), projectRoot, null);
        if (resolve) {
            this.outStream.println("\nResolving maven dependencies...");
            Dependency dependency = BindgenMvnResolver.resolveDependency(groupId, artifactId, version, mvnRepository.toString());
            BindgenMvnResolver.dependencyTraversal(dependency, mvnRepository.toString(), projectRoot);
            if (projectRoot != null) {
                this.outStream.println("\nUpdated the Ballerina.toml file with new platform libraries.");
            }
        }
    }

    private static void dependencyTraversal(Dependency dependency, String mvnRepository, Path projectRoot) throws BindgenException {
        if (dependency.getDepedencies() == null) {
            return;
        }
        String parent = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
        for (Dependency transitive : dependency.getDepedencies()) {
            BindgenMvnResolver.handleDependency(transitive.getGroupId(), transitive.getArtifactId(), transitive.getVersion(), mvnRepository, projectRoot, parent);
            BindgenMvnResolver.dependencyTraversal(transitive, mvnRepository, projectRoot);
        }
    }

    private static Dependency resolveDependency(String groupId, String artifactId, String version, String mvnRepository) throws BindgenException {
        MavenResolver resolver = new MavenResolver(mvnRepository);
        try {
            return resolver.resolve(groupId, artifactId, version, true);
        }
        catch (MavenResolverException e) {
            throw new BindgenException(e.getMessage());
        }
    }

    private static void handleDependency(String groupId, String artifactId, String version, String mvnRepository, Path projectRoot, String parent) throws BindgenException {
        File tomlFile;
        Path mvnPath = Paths.get(mvnRepository, BindgenMvnResolver.getPathFromGroupId(groupId), artifactId, version);
        BindingsGenerator.setClassPaths(mvnPath.toString());
        if (projectRoot != null && (tomlFile = new File(Paths.get(projectRoot.toString(), "Ballerina.toml").toString())).exists() && !tomlFile.isDirectory()) {
            BindgenMvnResolver.populateBallerinaToml(groupId, artifactId, version, tomlFile, projectRoot, parent);
        }
    }

    private static void populateBallerinaToml(String groupId, String artifactId, String version, File tomlFile, Path projectRoot, String parent) throws BindgenException {
        Manifest manifest = TomlParserUtils.getManifest((Path)projectRoot);
        try (FileWriterWithEncoding fileWriter = new FileWriterWithEncoding(tomlFile, StandardCharsets.UTF_8, true);){
            Platform platform = manifest.getPlatform();
            if (platform == null || platform.target == null && platform.libraries == null) {
                fileWriter.write("\n\n[platform]\n");
                fileWriter.write("target = \"java8\"\n");
            } else if (platform.getLibraries() != null) {
                for (Library library : platform.getLibraries()) {
                    if (library.path != null || library.groupId == null || library.artifactId == null || library.version == null || !library.groupId.equals(groupId) || !library.artifactId.equals(artifactId) || !library.version.equals(version)) continue;
                    return;
                }
            }
            fileWriter.write("\n");
            if (parent != null) {
                fileWriter.write("    # transitive dependency of " + parent + "\n");
            }
            fileWriter.write("    [[platform.libraries]]\n");
            String moduleName = BindgenMvnResolver.getModuleName(projectRoot, BindingsGenerator.getOutputPath());
            if (moduleName != null) {
                fileWriter.write("    modules = [\"" + moduleName + "\"]\n");
            }
            fileWriter.write("    groupId = \"" + groupId + "\"\n");
            fileWriter.write("    artifactId = \"" + artifactId + "\"\n");
            fileWriter.write("    version = \"" + version + "\"\n");
        }
        catch (IOException io) {
            throw new BindgenException("Error while updating the Ballerina.toml file.", io);
        }
    }

    private static String getPathFromGroupId(String groupId) {
        String[] paths = groupId.split("\\.");
        if (paths.length == 0) {
            return groupId;
        }
        File combined = new File(paths[0]);
        for (int i = 1; i < paths.length; ++i) {
            combined = new File(combined, paths[i]);
        }
        return combined.getPath();
    }

    private static String getModuleName(Path projectRoot, String outputPath) {
        String splitRegex;
        String[] splittedPath;
        String moduleName;
        if (outputPath == null) {
            outputPath = Paths.get(System.getProperty("user.dir"), new String[0]).toString();
        }
        if (ProjectDirs.isModuleExist((Path)projectRoot, (String)(moduleName = (splittedPath = outputPath.split(splitRegex = Pattern.quote(System.getProperty("file.separator"))))[splittedPath.length - 1]))) {
            return moduleName;
        }
        return null;
    }
}

