/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.util;

import com.github.dockerjava.core.util.FilePathUtil;
import com.github.dockerjava.core.util.TarDirWalker;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.FileUtils;

public class CompressArchiveUtil {
    private CompressArchiveUtil() {
    }

    static void addFileToTar(TarArchiveOutputStream tarArchiveOutputStream, Path file, String entryName) throws IOException {
        if (Files.isSymbolicLink(file)) {
            TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(entryName, 50);
            tarArchiveEntry.setLinkName(Files.readSymbolicLink(file).toString());
            tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
        } else {
            TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)tarArchiveOutputStream.createArchiveEntry(file.toFile(), entryName);
            if (file.toFile().canExecute()) {
                tarArchiveEntry.setMode(tarArchiveEntry.getMode() | 0x1ED);
            }
            tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
            if (file.toFile().isFile()) {
                try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
                    ByteStreams.copy((InputStream)input, (OutputStream)tarArchiveOutputStream);
                }
            }
        }
        tarArchiveOutputStream.closeArchiveEntry();
    }

    private static TarArchiveOutputStream buildTarStream(Path outputPath, boolean gZipped) throws IOException {
        BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));
        if (gZipped) {
            outputStream = new GzipCompressorOutputStream((OutputStream)outputStream);
        }
        TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream((OutputStream)outputStream);
        tarArchiveOutputStream.setLongFileMode(2);
        return tarArchiveOutputStream;
    }

    public static void tar(Path inputPath, Path outputPath, boolean gZipped, boolean childrenOnly) throws IOException {
        if (!Files.exists(inputPath, new LinkOption[0])) {
            throw new FileNotFoundException("File not found " + inputPath);
        }
        FileUtils.touch(outputPath.toFile());
        try (TarArchiveOutputStream tarArchiveOutputStream = CompressArchiveUtil.buildTarStream(outputPath, gZipped);){
            if (!Files.isDirectory(inputPath, new LinkOption[0])) {
                CompressArchiveUtil.addFileToTar(tarArchiveOutputStream, inputPath, inputPath.getFileName().toString());
            } else {
                Path sourcePath = inputPath;
                if (!childrenOnly) {
                    sourcePath = inputPath.getParent();
                }
                Files.walkFileTree(inputPath, new TarDirWalker(sourcePath, tarArchiveOutputStream));
            }
            tarArchiveOutputStream.flush();
        }
    }

    public static File archiveTARFiles(File base, Iterable<File> files, String archiveNameWithOutExtension) throws IOException {
        File tarFile = new File(FileUtils.getTempDirectoryPath(), archiveNameWithOutExtension + ".tar");
        tarFile.deleteOnExit();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(tarFile))));){
            tos.setLongFileMode(2);
            for (File file : files) {
                CompressArchiveUtil.addFileToTar(tos, file.toPath(), FilePathUtil.relativize(base.toPath(), file.toPath()));
            }
        }
        return tarFile;
    }
}

