/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.docker.generator.utils;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.ballerinax.docker.generator.exceptions.DockerGenException;

public class DockerGenUtils {
    private static final boolean debugEnabled = "true".equals(System.getenv("BAL_DOCKER_DEBUG"));
    private static final PrintStream out = System.out;

    public static void printDebug(String msg) {
        if (debugEnabled) {
            out.println("debug [docker client]: " + msg);
        }
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static void writeToFile(String context, Path targetFilePath) throws IOException {
        File newFile = targetFilePath.toFile();
        if (newFile.exists() && newFile.delete()) {
            Files.write(targetFilePath, context.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return;
        }
        if (newFile.getParentFile().mkdirs()) {
            Files.write(targetFilePath, context.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return;
        }
        Files.write(targetFilePath, context.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static String extractUberJarName(Path uberJarFilePath) {
        Path fileName;
        if (null != uberJarFilePath && null != (fileName = uberJarFilePath.getFileName()) && fileName.toString().endsWith(".jar")) {
            return fileName.toString().replace(".jar", "");
        }
        return null;
    }

    public static void copyFileOrDirectory(Path source, Path destination) throws DockerGenException {
        DockerGenUtils.printDebug("copying file(s) from `" + source + "` to `" + destination + "`.");
        File src = source.toFile();
        if (!src.exists()) {
            throw new DockerGenException("error while copying file/folder '" + source + "' as it does not exist");
        }
        File dst = destination.toFile();
        try {
            if (Files.isRegularFile(source, new LinkOption[0])) {
                if (Files.isDirectory(dst.toPath(), new LinkOption[0])) {
                    FileUtils.copyFileToDirectory(src, dst);
                } else {
                    FileUtils.copyFile(src, dst);
                }
            } else if (Files.isDirectory(source, new LinkOption[0])) {
                FileUtils.copyDirectory(src, dst);
            }
        }
        catch (IOException e) {
            throw new DockerGenException("error while copying file/folder '" + source + "' to '" + destination + "'", e);
        }
    }

    public static String cleanErrorMessage(String errorMessage) {
        errorMessage = errorMessage.replace("javax.ws.rs.ProcessingException:", "");
        errorMessage = errorMessage.replace("java.io.IOException:", "");
        errorMessage = errorMessage.replace("java.util.concurrent.ExecutionException:", "");
        errorMessage = errorMessage.replace("java.lang.IllegalArgumentException:", "");
        errorMessage = errorMessage.replace("org.apache.http.conn.HttpHostConnectException:", "");
        if ((errorMessage = errorMessage.replace("org.apache.http.client.ClientProtocolException:", "")).contains("unable to find valid certification path")) {
            errorMessage = "unable to find docker cert path.";
        } else if (errorMessage.contains("Connection refused")) {
            errorMessage = "connection refused to docker host";
        } else if (errorMessage.contains("Unable to connect to server")) {
            errorMessage = errorMessage.replace("Unable to connect to server: Timeout: GET", "unable to connect to docker host: ");
        } else if (errorMessage.toLowerCase(Locale.getDefault()).contains("permission denied")) {
            errorMessage = "permission denied for docker";
        }
        return DockerGenUtils.firstCharToLowerCase(errorMessage);
    }

    private static String firstCharToLowerCase(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        if (str.length() == 1) {
            return str.toLowerCase(Locale.getDefault());
        }
        char[] chArr = str.toCharArray();
        chArr[0] = Character.toLowerCase(chArr[0]);
        return new String(chArr);
    }
}

