/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes;

import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.ConfigMapHandler;
import org.ballerinax.kubernetes.handlers.DeploymentHandler;
import org.ballerinax.kubernetes.handlers.DockerHandler;
import org.ballerinax.kubernetes.handlers.HPAHandler;
import org.ballerinax.kubernetes.handlers.HelmChartHandler;
import org.ballerinax.kubernetes.handlers.IngressHandler;
import org.ballerinax.kubernetes.handlers.JobHandler;
import org.ballerinax.kubernetes.handlers.PersistentVolumeClaimHandler;
import org.ballerinax.kubernetes.handlers.ResourceQuotaHandler;
import org.ballerinax.kubernetes.handlers.SecretHandler;
import org.ballerinax.kubernetes.handlers.ServiceHandler;
import org.ballerinax.kubernetes.handlers.istio.IstioGatewayHandler;
import org.ballerinax.kubernetes.handlers.istio.IstioVirtualServiceHandler;
import org.ballerinax.kubernetes.handlers.openshift.OpenShiftBuildConfigHandler;
import org.ballerinax.kubernetes.handlers.openshift.OpenShiftImageStreamHandler;
import org.ballerinax.kubernetes.handlers.openshift.OpenShiftRouteHandler;
import org.ballerinax.kubernetes.models.DeploymentModel;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.KubernetesDataHolder;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class ArtifactManager {
    private static final Map<String, String> instructions = new LinkedHashMap<String, String>();
    private static final PrintStream OUT = System.out;
    private KubernetesDataHolder kubernetesDataHolder = KubernetesContext.getInstance().getDataHolder();

    ArtifactManager() {
    }

    void createArtifacts() throws KubernetesPluginException {
        this.setDefaultKubernetesInstructions();
        OUT.println("\nGenerating artifacts...");
        if (this.kubernetesDataHolder.getJobModel() != null) {
            new JobHandler().createArtifacts();
            new DockerHandler().createArtifacts();
        } else {
            new ServiceHandler().createArtifacts();
            new IngressHandler().createArtifacts();
            new SecretHandler().createArtifacts();
            new PersistentVolumeClaimHandler().createArtifacts();
            new ResourceQuotaHandler().createArtifacts();
            new ConfigMapHandler().createArtifacts();
            new DeploymentHandler().createArtifacts();
            new HPAHandler().createArtifacts();
            new DockerHandler().createArtifacts();
            new HelmChartHandler().createArtifacts();
            new IstioGatewayHandler().createArtifacts();
            new IstioVirtualServiceHandler().createArtifacts();
            if (this.kubernetesDataHolder.getOpenShiftBuildExtensionModel() != null || this.kubernetesDataHolder.getOpenShiftRouteModels().size() > 0) {
                instructions.clear();
                new OpenShiftBuildConfigHandler().createArtifacts();
                new OpenShiftImageStreamHandler().createArtifacts();
                new OpenShiftRouteHandler().createArtifacts();
            }
        }
        this.printInstructions();
    }

    private void printInstructions() {
        KubernetesUtils.printInstruction("");
        KubernetesUtils.printInstruction("");
        for (Map.Entry<String, String> instruction : instructions.entrySet()) {
            KubernetesUtils.printInstruction(instruction.getKey());
            KubernetesUtils.printInstruction(instruction.getValue());
            KubernetesUtils.printInstruction("");
        }
    }

    public void populateDeploymentModel() {
        DeploymentModel deploymentModel = this.kubernetesDataHolder.getDeploymentModel();
        this.kubernetesDataHolder.setDeploymentModel(deploymentModel);
        String balxFileName = DockerGenUtils.extractUberJarName(this.kubernetesDataHolder.getUberJarPath());
        if (KubernetesUtils.isBlank(deploymentModel.getName()) && balxFileName != null) {
            deploymentModel.setName(KubernetesUtils.getValidName(balxFileName) + "-deployment");
        }
        if (KubernetesUtils.isBlank(deploymentModel.getImage())) {
            deploymentModel.setImage(balxFileName + ":latest");
        }
        deploymentModel.addLabel("app", balxFileName);
        this.kubernetesDataHolder.setDeploymentModel(deploymentModel);
    }

    public static Map<String, String> getInstructions() {
        return instructions;
    }

    private void setDefaultKubernetesInstructions() {
        instructions.put("\tRun the following command to deploy the Kubernetes artifacts: ", "\tkubectl apply -f " + this.kubernetesDataHolder.getK8sArtifactOutputPath().toAbsolutePath());
        DeploymentModel model = this.kubernetesDataHolder.getDeploymentModel();
        instructions.put("\tRun the following command to install the application using Helm: ", "\thelm install --name " + model.getName() + " " + this.kubernetesDataHolder.getK8sArtifactOutputPath().resolve(model.getName()).toAbsolutePath());
    }
}

