/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes;

import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.knative.KnativeConfigMapHandler;
import org.ballerinax.kubernetes.handlers.knative.KnativeContainerHandler;
import org.ballerinax.kubernetes.handlers.knative.KnativeDockerHandler;
import org.ballerinax.kubernetes.handlers.knative.KnativeResourceQuotaHandler;
import org.ballerinax.kubernetes.handlers.knative.KnativeSecretHandler;
import org.ballerinax.kubernetes.handlers.knative.KnativeServiceHandler;
import org.ballerinax.kubernetes.models.knative.KnativeContext;
import org.ballerinax.kubernetes.models.knative.KnativeDataHolder;
import org.ballerinax.kubernetes.models.knative.ServiceModel;
import org.ballerinax.kubernetes.utils.KnativeUtils;

public class KnativeArtifactManager {
    private static final Map<String, String> instructions = new LinkedHashMap<String, String>();
    private static final PrintStream OUT = System.out;
    private KnativeDataHolder knativeDataHolder = KnativeContext.getInstance().getDataHolder();

    KnativeArtifactManager() {
    }

    void createArtifacts() throws KubernetesPluginException {
        this.setDefaultKnativeInstructions();
        OUT.println("\nGenerating Knative artifacts...");
        new KnativeContainerHandler().createArtifacts();
        new KnativeSecretHandler().createArtifacts();
        new KnativeResourceQuotaHandler().createArtifacts();
        new KnativeConfigMapHandler().createArtifacts();
        new KnativeServiceHandler().createArtifacts();
        new KnativeDockerHandler().createArtifacts();
        this.printInstructions();
    }

    private void printInstructions() {
        KnativeUtils.printInstruction("");
        KnativeUtils.printInstruction("");
        for (Map.Entry<String, String> instruction : instructions.entrySet()) {
            KnativeUtils.printInstruction(instruction.getKey());
            KnativeUtils.printInstruction(instruction.getValue());
            KnativeUtils.printInstruction("");
        }
    }

    public void populateDeploymentModel() {
        ServiceModel serviceModel = this.knativeDataHolder.getServiceModel();
        this.knativeDataHolder.setServiceModel(serviceModel);
        String balxFileName = DockerGenUtils.extractUberJarName(this.knativeDataHolder.getUberJarPath());
        if (KnativeUtils.isBlank(serviceModel.getName()) && balxFileName != null) {
            serviceModel.setName(KnativeUtils.getValidName(balxFileName) + "-deployment");
        }
        if (KnativeUtils.isBlank(serviceModel.getImage())) {
            serviceModel.setImage(balxFileName + ":latest");
        }
        serviceModel.addLabel("app", balxFileName);
        this.knativeDataHolder.setServiceModel(serviceModel);
    }

    public static Map<String, String> getInstructions() {
        return instructions;
    }

    private void setDefaultKnativeInstructions() {
        instructions.put("\tRun the following command to deploy the Knative artifacts: ", "\tkubectl apply -f " + this.knativeDataHolder.getK8sArtifactOutputPath().toAbsolutePath());
        ServiceModel model = this.knativeDataHolder.getServiceModel();
        instructions.put("\tRun the following command to install the application using Helm: ", "\thelm install --name " + model.getName() + " " + this.knativeDataHolder.getK8sArtifactOutputPath().resolve(model.getName()).toAbsolutePath());
    }
}

