/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.DeploymentModel;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class HelmChartHandler
extends AbstractArtifactHandler {
    @Override
    public void createArtifacts() throws KubernetesPluginException {
        DeploymentModel model = this.dataHolder.getDeploymentModel();
        OUT.println();
        Path helmBaseOutputDir = this.dataHolder.getK8sArtifactOutputPath();
        if (helmBaseOutputDir.endsWith("target" + File.separator + "kubernetes" + File.separator)) {
            helmBaseOutputDir = helmBaseOutputDir.resolve(DockerGenUtils.extractUberJarName(this.dataHolder.getUberJarPath()));
        }
        helmBaseOutputDir = helmBaseOutputDir.resolve(model.getName());
        String helmTemplatesOutputDir = helmBaseOutputDir + File.separator + "templates";
        new File(helmTemplatesOutputDir).mkdirs();
        this.copyKubernetesArtifactsToHelmTemplates(helmTemplatesOutputDir);
        this.generateChartYAML(helmBaseOutputDir);
        OUT.print("\t@kubernetes:Helm \t\t\t - complete 1/1");
    }

    private void copyKubernetesArtifactsToHelmTemplates(String helmTemplatesOutputDir) throws KubernetesPluginException {
        File dir = this.dataHolder.getK8sArtifactOutputPath().toFile();
        File[] yamlFiles = dir.listFiles(new KubernetesArtifactsFileFilter());
        if (yamlFiles == null) {
            throw new KubernetesPluginException("kuberenetes artifacts not available to generate Helm templates");
        }
        for (File yamlFile : yamlFiles) {
            KubernetesUtils.copyFileOrDirectory(yamlFile.getAbsolutePath(), helmTemplatesOutputDir + File.separator + yamlFile.getName());
        }
    }

    private void generateChartYAML(Path helmBaseOutputDir) throws KubernetesPluginException {
        DeploymentModel model = this.dataHolder.getDeploymentModel();
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("apiVersion", "v1");
        values.put("appVersion", "1.0");
        values.put("description", "Helm chart for " + model.getName());
        values.put("name", model.getName());
        values.put("version", model.getVersion() == null ? "0.1.0" : model.getVersion());
        try (FileWriter writer = new FileWriter(helmBaseOutputDir.resolve("Chart.yaml").toString());){
            yaml.dump(values, (Writer)writer);
        }
        catch (IOException e) {
            throw new KubernetesPluginException("error in generating the Helm chart: " + e.getMessage(), e);
        }
    }

    private static class KubernetesArtifactsFileFilter
    implements FilenameFilter {
        private KubernetesArtifactsFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase(Locale.getDefault()).endsWith(".yaml");
        }
    }
}

