/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers;

import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackend;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLS;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLSBuilder;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.IngressModel;
import org.ballerinax.kubernetes.models.SecretModel;
import org.ballerinax.kubernetes.models.ServiceModel;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class IngressHandler
extends AbstractArtifactHandler {
    private void generate(IngressModel ingressModel) throws KubernetesPluginException {
        Map<String, String> userDefinedAnnotationMap;
        IngressBackend ingressBackend = ((IngressBackendBuilder)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressBackendFluent.ServiceNested)new IngressBackendBuilder().withNewService().withName(ingressModel.getServiceName())).withNewPort().withNumber(ingressModel.getServicePort())).endPort()).endService()).build();
        HTTPIngressPath ingressPath = ((HTTPIngressPathBuilder)((HTTPIngressPathBuilder)((HTTPIngressPathBuilder)new HTTPIngressPathBuilder().withBackend(ingressBackend)).withPathType("Prefix")).withPath(ingressModel.getPath())).build();
        ArrayList<IngressTLS> ingressTLS = new ArrayList<IngressTLS>();
        if (ingressModel.isEnableTLS()) {
            ingressTLS.add(((IngressTLSBuilder)new IngressTLSBuilder().withHosts(ingressModel.getHostname())).build());
        }
        HashMap<String, String> annotationMap = new HashMap<String, String>();
        annotationMap.put("kubernetes.io/ingress.class", ingressModel.getIngressClass());
        if ("nginx".equals(ingressModel.getIngressClass())) {
            annotationMap.put("nginx.ingress.kubernetes.io/ssl-passthrough", String.valueOf(ingressModel.isEnableTLS()));
            if (ingressModel.isEnableTLS()) {
                annotationMap.put("nginx.ingress.kubernetes.io/backend-protocol", "HTTPS");
            }
            if (ingressModel.getTargetPath() != null) {
                annotationMap.put("nginx.ingress.kubernetes.io/rewrite-target", ingressModel.getTargetPath());
            }
        }
        if ((userDefinedAnnotationMap = ingressModel.getAnnotations()) != null) {
            userDefinedAnnotationMap.forEach(annotationMap::putIfAbsent);
        }
        Ingress ingress = ((IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((IngressSpecFluent.RulesNested)((IngressFluent.SpecNested)((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName(ingressModel.getName())).withNamespace(this.dataHolder.getNamespace())).addToLabels(ingressModel.getLabels())).addToAnnotations(annotationMap)).endMetadata()).withNewSpec().withTls(ingressTLS)).addNewRule().withHost(ingressModel.getHostname())).withNewHttp().withPaths(ingressPath)).endHttp()).endRule()).endSpec()).build();
        try {
            String ingressYAML = SerializationUtils.dumpWithoutRuntimeStateAsYaml(ingress);
            KubernetesUtils.writeToFile(ingressYAML, "_ingress.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for ingress: " + ingressModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        Set<IngressModel> ingressModels = this.dataHolder.getIngressModelSet();
        int size = ingressModels.size();
        if (size > 0) {
            OUT.println();
        }
        int count = 0;
        Map<String, Set<SecretModel>> secretModelsMap = this.dataHolder.getSecretModels();
        for (IngressModel ingressModel : ingressModels) {
            ServiceModel serviceModel = this.dataHolder.getServiceModel(ingressModel.getListenerName());
            if (serviceModel == null) {
                throw new KubernetesPluginException("@kubernetes:Ingress annotation must be followed by @kubernetes:Service annotation.");
            }
            ingressModel.setServiceName(serviceModel.getName());
            ingressModel.setServicePort(serviceModel.getPort());
            String balxFileName = DockerGenUtils.extractUberJarName(this.dataHolder.getUberJarPath());
            ingressModel.getLabels().put("app", balxFileName);
            if (secretModelsMap.get(ingressModel.getListenerName()) != null && secretModelsMap.get(ingressModel.getListenerName()).size() != 0) {
                ingressModel.setEnableTLS(true);
            }
            this.generate(ingressModel);
            OUT.print("\t@kubernetes:Ingress \t\t\t - complete " + ++count + "/" + size + "\r");
        }
    }
}

