/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.CronJob;
import io.fabric8.kubernetes.api.model.batch.CronJobBuilder;
import io.fabric8.kubernetes.api.model.batch.CronJobFluent;
import io.fabric8.kubernetes.api.model.batch.CronJobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.kubernetes.api.model.batch.JobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.JobTemplateSpecFluent;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ballerinax.docker.generator.exceptions.DockerGenException;
import org.ballerinax.docker.generator.models.DockerModel;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.JobModel;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class JobHandler
extends AbstractArtifactHandler {
    private void generate(JobModel jobModel) throws KubernetesPluginException {
        try {
            String jobContent = KubernetesUtils.isBlank(jobModel.getSchedule()) ? SerializationUtils.dumpWithoutRuntimeStateAsYaml(this.getJob(jobModel)) : SerializationUtils.dumpWithoutRuntimeStateAsYaml(this.getCronJob(jobModel));
            KubernetesUtils.writeToFile(jobContent, "_job.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for job " + jobModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    private Container generateContainer(JobModel jobModel) {
        return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(jobModel.getName())).withImage(jobModel.getImage())).withImagePullPolicy(jobModel.getImagePullPolicy())).withEnv(KubernetesUtils.populateEnvVar(jobModel.getEnv()))).build();
    }

    private Job getJob(JobModel jobModel) {
        JobBuilder jobBuilder = (JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName(jobModel.getName())).withNamespace(this.dataHolder.getNamespace())).endMetadata()).withNewSpec().withNewTemplate().withNewSpec().withRestartPolicy(jobModel.getRestartPolicy())).withContainers(this.generateContainer(jobModel))).withImagePullSecrets(this.getImagePullSecrets(jobModel))).withNodeSelector(jobModel.getNodeSelector())).endSpec()).endTemplate()).endSpec();
        return jobBuilder.build();
    }

    private List<LocalObjectReference> getImagePullSecrets(JobModel jobModel) {
        ArrayList<LocalObjectReference> imagePullSecrets = new ArrayList<LocalObjectReference>();
        for (String imagePullSecret : jobModel.getImagePullSecrets()) {
            imagePullSecrets.add(((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(imagePullSecret)).build());
        }
        return imagePullSecrets;
    }

    private CronJob getCronJob(JobModel jobModel) {
        return ((CronJobBuilder)((CronJobFluent.SpecNested)((CronJobSpecFluent.JobTemplateNested)((JobTemplateSpecFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((CronJobFluent.SpecNested)((CronJobBuilder)((CronJobFluent.MetadataNested)new CronJobBuilder().withNewMetadata().withName(jobModel.getName())).endMetadata()).withNewSpec().withSchedule(jobModel.getSchedule())).withNewJobTemplate().withNewSpec().withNewTemplate().withNewSpec().withRestartPolicy(jobModel.getRestartPolicy())).withContainers(this.generateContainer(jobModel))).endSpec()).endTemplate()).endSpec()).endJobTemplate()).endSpec()).build();
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        try {
            String balxFileName = DockerGenUtils.extractUberJarName(this.dataHolder.getUberJarPath());
            JobModel jobModel = this.dataHolder.getJobModel();
            if (KubernetesUtils.isBlank(jobModel.getName())) {
                jobModel.setName(KubernetesUtils.getValidName(balxFileName) + "-job");
            }
            if (KubernetesUtils.isBlank(jobModel.getImage())) {
                jobModel.setImage(balxFileName + ":latest");
            }
            jobModel.addLabel("app", balxFileName);
            this.generate(jobModel);
            this.dataHolder.setDockerModel(this.getDockerModel(jobModel));
            OUT.println();
            OUT.print("\t@kubernetes:Job \t\t\t - complete 1/1");
        }
        catch (DockerGenException e) {
            throw new KubernetesPluginException("error occurred creating docker image.", e);
        }
    }

    private DockerModel getDockerModel(JobModel jobModel) throws DockerGenException {
        DockerModel dockerModel = new DockerModel();
        String dockerImage = jobModel.getImage();
        String imageTag = dockerImage.substring(dockerImage.lastIndexOf(":") + 1);
        dockerImage = dockerImage.substring(0, dockerImage.lastIndexOf(":"));
        dockerModel.setBaseImage(jobModel.getBaseImage());
        dockerModel.setRegistry(jobModel.getRegistry());
        dockerModel.setName(dockerImage);
        dockerModel.setTag(imageTag);
        dockerModel.setUsername(jobModel.getUsername());
        dockerModel.setPassword(jobModel.getPassword());
        dockerModel.setPush(jobModel.isPush());
        dockerModel.setCmd(jobModel.getCmd());
        dockerModel.setUberJarFileName(DockerGenUtils.extractUberJarName(this.dataHolder.getUberJarPath()) + ".jar");
        dockerModel.setService(false);
        dockerModel.setDockerHost(jobModel.getDockerHost());
        dockerModel.setDockerCertPath(jobModel.getDockerCertPath());
        dockerModel.setBuildImage(jobModel.isBuildImage());
        dockerModel.setCopyFiles(jobModel.getCopyFiles());
        return dockerModel;
    }
}

