/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers;

import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.PersistentVolumeClaimModel;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class PersistentVolumeClaimHandler
extends AbstractArtifactHandler {
    private void generate(PersistentVolumeClaimModel volumeClaimModel) throws KubernetesPluginException {
        Quantity quantity = ((QuantityBuilder)new QuantityBuilder().withAmount(volumeClaimModel.getVolumeClaimSize())).build();
        HashMap<String, Quantity> requests = new HashMap<String, Quantity>();
        requests.put("storage", quantity);
        PersistentVolumeClaim claim = ((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimSpecFluent.ResourcesNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluent.MetadataNested)new PersistentVolumeClaimBuilder().withNewMetadata().withName(volumeClaimModel.getName())).withNamespace(this.dataHolder.getNamespace())).withAnnotations(volumeClaimModel.getAnnotations())).endMetadata()).withNewSpec().withAccessModes(volumeClaimModel.getAccessMode())).withNewResources().withRequests(requests)).endResources()).endSpec()).build();
        try {
            String claimContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(claim);
            KubernetesUtils.writeToFile(claimContent, "_volume_claim.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for volume claim: " + volumeClaimModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        int count = 0;
        Set<PersistentVolumeClaimModel> volumeClaims = this.dataHolder.getVolumeClaimModelSet();
        if (volumeClaims.size() > 0) {
            OUT.println();
        }
        for (PersistentVolumeClaimModel claimModel : volumeClaims) {
            this.generate(claimModel);
            OUT.print("\t@kubernetes:VolumeClaim \t\t - complete " + ++count + "/" + volumeClaims.size() + "\r");
        }
    }
}

