/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.Map;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.DeploymentModel;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.ServiceModel;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class ServiceHandler
extends AbstractArtifactHandler {
    private void generate(ServiceModel serviceModel) throws KubernetesPluginException {
        if (null == serviceModel.getPortName()) {
            serviceModel.setPortName(serviceModel.getProtocol() + "-" + serviceModel.getName());
        }
        ServicePortBuilder servicePortBuilder = (ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(serviceModel.getPortName())).withProtocol("TCP")).withPort(serviceModel.getPort())).withNewTargetPort(serviceModel.getTargetPort());
        if (serviceModel.getNodePort() > 0) {
            servicePortBuilder.withNodePort(serviceModel.getNodePort());
        }
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(serviceModel.getName())).withNamespace(this.dataHolder.getNamespace())).addToLabels(serviceModel.getLabels())).endMetadata()).withNewSpec().withPorts(servicePortBuilder.build())).addToSelector("app", serviceModel.getSelector())).withSessionAffinity(serviceModel.getSessionAffinity())).withType(serviceModel.getServiceType())).endSpec()).build();
        try {
            String serviceYAML = SerializationUtils.dumpWithoutRuntimeStateAsYaml(service);
            KubernetesUtils.writeToFile(serviceYAML, "_svc.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for service: " + serviceModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        DeploymentModel deploymentModel = this.dataHolder.getDeploymentModel();
        Map<String, ServiceModel> serviceModels = this.dataHolder.getbListenerToK8sServiceMap();
        int count = 0;
        for (ServiceModel serviceModel : serviceModels.values()) {
            ++count;
            String balxFileName = DockerGenUtils.extractUberJarName(KubernetesContext.getInstance().getDataHolder().getUberJarPath());
            serviceModel.addLabel("app", balxFileName);
            serviceModel.setSelector(balxFileName);
            this.generate(serviceModel);
            if (deploymentModel.isPrometheus()) {
                deploymentModel.setPrometheusPort(serviceModel.getPrometheusModel().getPort());
                this.generatePrometheusService(serviceModel);
            }
            deploymentModel.addPort(serviceModel.getTargetPort());
            OUT.println();
            OUT.print("\t@kubernetes:Service \t\t\t - complete " + count + "/" + serviceModels.size() + "\r");
        }
    }

    private void generatePrometheusService(ServiceModel serviceModel) throws KubernetesPluginException {
        ServicePortBuilder servicePortBuilder = (ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(serviceModel.getProtocol() + "-prometheus-" + serviceModel.getName())).withProtocol("TCP")).withPort(serviceModel.getPrometheusModel().getPort())).withNewTargetPort(serviceModel.getPrometheusModel().getPort());
        if (serviceModel.getPrometheusModel().getNodePort() > 0) {
            servicePortBuilder.withNodePort(serviceModel.getNodePort());
        }
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(serviceModel.getName() + "-prometheus")).withNamespace(this.dataHolder.getNamespace())).addToLabels(serviceModel.getLabels())).endMetadata()).withNewSpec().withPorts(servicePortBuilder.build())).addToSelector("app", serviceModel.getSelector())).withSessionAffinity(serviceModel.getSessionAffinity())).withType(serviceModel.getPrometheusModel().getServiceType())).endSpec()).build();
        try {
            String serviceYAML = SerializationUtils.dumpWithoutRuntimeStateAsYaml(service);
            KubernetesUtils.writeToFile(serviceYAML, "_prometheus_svc.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for prometheus service: " + serviceModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }
}

