/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers.istio;

import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.snowdrop.istio.api.networking.v1alpha3.Gateway;
import me.snowdrop.istio.api.networking.v1alpha3.GatewayBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.GatewayFluent;
import me.snowdrop.istio.api.networking.v1alpha3.Server;
import me.snowdrop.istio.api.networking.v1alpha3.ServerBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.ServerFluent;
import me.snowdrop.istio.api.networking.v1alpha3.TLSOptions;
import me.snowdrop.istio.api.networking.v1alpha3.TLSOptionsBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.TLSOptionsMode;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.istio.IstioGatewayModel;
import org.ballerinax.kubernetes.models.istio.IstioServerModel;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class IstioGatewayHandler
extends AbstractArtifactHandler {
    @Override
    public void createArtifacts() throws KubernetesPluginException {
        Map<String, IstioGatewayModel> gatewayModels = this.dataHolder.getIstioGatewayModels();
        int size = gatewayModels.size();
        if (size > 0) {
            OUT.println();
        }
        int count = 0;
        for (IstioGatewayModel gatewayModel : gatewayModels.values()) {
            ++count;
            if (null == gatewayModel.getSelector() || gatewayModel.getSelector().size() == 0) {
                LinkedHashMap<String, String> selectors = new LinkedHashMap<String, String>();
                selectors.put("istio", "ingressgateway");
                gatewayModel.setSelector(selectors);
            }
            if (null == gatewayModel.getServers() || gatewayModel.getServers().size() == 0) {
                throw new KubernetesPluginException("'" + gatewayModel.getName() + "' istio gateway needs one or more servers.");
            }
            for (IstioServerModel serverModel : gatewayModel.getServers()) {
                if (null == serverModel.getHosts() || serverModel.getHosts().size() == 0) {
                    throw new KubernetesPluginException("'" + gatewayModel.getName() + "' istio gateway needs one or more server hosts.");
                }
                if (null == serverModel.getPort() || serverModel.getPort().getNumber() < 0) {
                    throw new KubernetesPluginException("'" + gatewayModel.getName() + "' istio gateway ports cannot be less than 0. found: " + serverModel.getPort().getNumber());
                }
                if (serverModel.getTls() != null && "SIMPLE".equals(serverModel.getTls().getMode()) && (serverModel.getTls().getServerCertificate() == null || serverModel.getTls().getPrivateKey() == null)) {
                    throw new KubernetesPluginException("'" + gatewayModel.getName() + "' istio gateway TLS mode is SIMPLE, hence serverCertificate and privateKey fields are required.");
                }
                if (serverModel.getTls() == null || !"MUTUAL".equals(serverModel.getTls().getMode()) || serverModel.getTls().getServerCertificate() != null && serverModel.getTls().getPrivateKey() != null && serverModel.getTls().getCaCertificates() != null) continue;
                throw new KubernetesPluginException("'" + gatewayModel.getName() + "' istio gateway TLS mode is MUTUAL, hence serverCertificate, privateKey and caCertificates fields are required.");
            }
            this.generate(gatewayModel);
            OUT.print("\t@istio:Gateway \t\t\t\t - complete " + count + "/" + size + "\r");
        }
    }

    private void generate(IstioGatewayModel gatewayModel) throws KubernetesPluginException {
        try {
            Gateway gateway = ((GatewayBuilder)((GatewayFluent.SpecNested)((GatewayFluent.SpecNested)((GatewayBuilder)((GatewayFluent.MetadataNested)((GatewayFluent.MetadataNested)((GatewayFluent.MetadataNested)((GatewayFluent.MetadataNested)new GatewayBuilder().withNewMetadata().withName(gatewayModel.getName())).withNamespace(this.dataHolder.getNamespace())).withLabels(gatewayModel.getLabels())).withAnnotations(gatewayModel.getAnnotations())).endMetadata()).withNewSpec().withSelector(gatewayModel.getSelector())).withServers(this.populateServers(gatewayModel.getServers()))).endSpec()).build();
            String gatewayContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(gateway);
            KubernetesUtils.writeToFile(gatewayContent, "_istio_gateway.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for istio gateway: " + gatewayModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    private List<Server> populateServers(List<IstioServerModel> serverModels) {
        return serverModels.stream().map(serverModel -> ((ServerBuilder)((ServerBuilder)((ServerFluent.PortNested)((ServerFluent.PortNested)((ServerFluent.PortNested)((ServerBuilder)new ServerBuilder().withHosts(new ArrayList<String>(serverModel.getHosts()))).withNewPort().withNumber(serverModel.getPort().getNumber())).withProtocol(serverModel.getPort().getProtocol())).withName(serverModel.getPort().getName())).endPort()).withTls(this.populateTLS(serverModel.getTls()))).build()).collect(Collectors.toList());
    }

    private TLSOptions populateTLS(IstioServerModel.TLSOptions tls) {
        if (null == tls) {
            return null;
        }
        return ((TLSOptionsBuilder)((TLSOptionsBuilder)((TLSOptionsBuilder)((TLSOptionsBuilder)((TLSOptionsBuilder)((TLSOptionsBuilder)new TLSOptionsBuilder().withHttpsRedirect(tls.isHttpsRedirect())).withMode(TLSOptionsMode.valueOf(tls.getMode()))).withServerCertificate(tls.getServerCertificate())).withPrivateKey(tls.getPrivateKey())).withCaCertificates(tls.getCaCertificates())).withSubjectAltNames(new ArrayList<String>(tls.getSubjectAltNames()))).build();
    }
}

