/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers.istio;

import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.snowdrop.istio.api.Duration;
import me.snowdrop.istio.api.DurationBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.Destination;
import me.snowdrop.istio.api.networking.v1alpha3.DestinationBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.HTTPRoute;
import me.snowdrop.istio.api.networking.v1alpha3.HTTPRouteBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.HTTPRouteDestination;
import me.snowdrop.istio.api.networking.v1alpha3.HTTPRouteDestinationBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.PortSelectorBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.VirtualService;
import me.snowdrop.istio.api.networking.v1alpha3.VirtualServiceBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.VirtualServiceFluent;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.ServiceModel;
import org.ballerinax.kubernetes.models.istio.IstioDestination;
import org.ballerinax.kubernetes.models.istio.IstioDestinationWeight;
import org.ballerinax.kubernetes.models.istio.IstioGatewayModel;
import org.ballerinax.kubernetes.models.istio.IstioHttpRoute;
import org.ballerinax.kubernetes.models.istio.IstioVirtualServiceModel;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class IstioVirtualServiceHandler
extends AbstractArtifactHandler {
    @Override
    public void createArtifacts() throws KubernetesPluginException {
        Map<String, IstioVirtualServiceModel> istioVSModels = this.dataHolder.getIstioVirtualServiceModels();
        int size = istioVSModels.size();
        if (size > 0) {
            OUT.println();
        }
        int count = 0;
        for (Map.Entry<String, IstioVirtualServiceModel> vsModel : istioVSModels.entrySet()) {
            ++count;
            IstioGatewayModel gwModel = KubernetesContext.getInstance().getDataHolder().getIstioGatewayModel(vsModel.getKey());
            if ((null == vsModel.getValue().getGateways() || vsModel.getValue().getGateways().size() == 0) && null != gwModel) {
                if (null == vsModel.getValue().getGateways()) {
                    vsModel.getValue().setGateways(new LinkedList<String>());
                }
                if (vsModel.getValue().getGateways().size() == 0) {
                    vsModel.getValue().getGateways().add(gwModel.getName());
                } else if (vsModel.getValue().getHosts().size() == 1 && vsModel.getValue().getHosts().contains("*")) {
                    throw new KubernetesPluginException("unable to resolve a gateway for '" + vsModel + "' virtual service. Add @istio:Gateway{} annotation to your listener or service, else explicitly state to use the 'mesh' gateway.");
                }
            }
            this.generate(vsModel.getKey(), vsModel.getValue());
            OUT.print("\t@istio:VirtualService \t\t\t - complete " + count + "/" + size + "\r");
        }
    }

    private void generate(String serviceName, IstioVirtualServiceModel vsModel) throws KubernetesPluginException {
        try {
            VirtualService virtualService = ((VirtualServiceBuilder)((VirtualServiceFluent.SpecNested)((VirtualServiceFluent.SpecNested)((VirtualServiceFluent.SpecNested)((VirtualServiceBuilder)((VirtualServiceFluent.MetadataNested)((VirtualServiceFluent.MetadataNested)((VirtualServiceFluent.MetadataNested)((VirtualServiceFluent.MetadataNested)new VirtualServiceBuilder().withNewMetadata().withName(vsModel.getName())).withNamespace(this.dataHolder.getNamespace())).withLabels(vsModel.getLabels())).withAnnotations(vsModel.getAnnotations())).endMetadata()).withNewSpec().withHosts(vsModel.getHosts())).withGateways(vsModel.getGateways())).withHttp(this.populateHttp(serviceName, vsModel.getHttp()))).endSpec()).build();
            String gatewayContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(virtualService);
            KubernetesUtils.writeToFile(gatewayContent, "_istio_virtual_service.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for istio virtual service: " + vsModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    private List<HTTPRoute> populateHttp(String serviceName, List<IstioHttpRoute> httpRouteModels) {
        if (null == httpRouteModels) {
            httpRouteModels = new LinkedList<IstioHttpRoute>();
        }
        if (httpRouteModels.size() == 0) {
            httpRouteModels.add(new IstioHttpRoute());
        }
        LinkedList<HTTPRoute> httpRoutes = new LinkedList<HTTPRoute>();
        for (IstioHttpRoute httpRouteModel : httpRouteModels) {
            Duration timoutDuration = null;
            if (-1L != httpRouteModel.getTimeout()) {
                timoutDuration = ((DurationBuilder)new DurationBuilder().withSeconds(httpRouteModel.getTimeout())).build();
            }
            HTTPRoute httpRoute = ((HTTPRouteBuilder)((HTTPRouteBuilder)((HTTPRouteBuilder)new HTTPRouteBuilder().withRoute(this.populateRouteList(serviceName, httpRouteModel.getRoute()))).withTimeout(timoutDuration)).withAppendHeaders(httpRouteModel.getAppendHeaders())).build();
            httpRoutes.add(httpRoute);
        }
        return httpRoutes;
    }

    private List<HTTPRouteDestination> populateRouteList(String serviceName, List<IstioDestinationWeight> routeModels) {
        if (routeModels == null) {
            routeModels = new LinkedList<IstioDestinationWeight>();
        }
        if (routeModels.size() == 0) {
            routeModels.add(new IstioDestinationWeight());
        }
        LinkedList<HTTPRouteDestination> destinationWeightList = new LinkedList<HTTPRouteDestination>();
        for (IstioDestinationWeight destinationWeightModel : routeModels) {
            HTTPRouteDestination routeDestination = ((HTTPRouteDestinationBuilder)((HTTPRouteDestinationBuilder)new HTTPRouteDestinationBuilder().withWeight(destinationWeightModel.getWeight())).withDestination(this.populateDestination(serviceName, destinationWeightModel.getDestination()))).build();
            destinationWeightList.add(routeDestination);
        }
        return destinationWeightList;
    }

    private Destination populateDestination(String serviceName, IstioDestination destination) {
        if (null == destination) {
            destination = new IstioDestination();
        }
        ServiceModel serviceModel = KubernetesContext.getInstance().getDataHolder().getServiceModel(serviceName);
        if (null == destination.getHost()) {
            destination.setHost(serviceModel.getName());
        }
        if (-1 == destination.getPort()) {
            destination.setPort(serviceModel.getPort());
        }
        return ((DestinationBuilder)((DestinationBuilder)((DestinationBuilder)new DestinationBuilder().withHost(destination.getHost())).withSubset(destination.getSubset())).withPort(((PortSelectorBuilder)new PortSelectorBuilder().withNewNumberPort(serviceModel.getPort())).build())).build();
    }
}

