/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers.knative;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.Set;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.knative.KnativeAbstractArtifactHandler;
import org.ballerinax.kubernetes.models.knative.SecretModel;
import org.ballerinax.kubernetes.utils.KnativeUtils;

public class KnativeSecretHandler
extends KnativeAbstractArtifactHandler {
    private void generate(SecretModel secretModel) throws KubernetesPluginException {
        Secret secret = ((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withNamespace(this.knativeDataHolder.getNamespace())).withName(secretModel.getName())).endMetadata()).withData(secretModel.getData())).build();
        try {
            String secretContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(secret);
            KnativeUtils.writeToFile(secretContent, "_secret.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for secret: " + secretModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        int count = 0;
        Set<SecretModel> secretModels = this.knativeDataHolder.getSecretModelSet();
        if (secretModels.size() > 0) {
            OUT.println();
        }
        for (SecretModel secretModel : secretModels) {
            this.generate(secretModel);
            OUT.print("\t@kubernetes:Secret \t\t\t - complete " + ++count + "/" + secretModels.size() + "\r");
        }
    }
}

